<?php
namespace AcademyPro\Admin;

use AcademyPro\Classes\QuizExport;
use AcademyPro\Classes\QuizAttemptExport;
use AcademyPro\Classes\StudentsExport;
use AcademyPro\Classes\InstructorsExport;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Export {
	public static function init() {
		$self = new self();
		add_action( 'admin_init', [ $self, 'quiz_export_data' ], -1 );
		add_action( 'admin_init', [ $self, 'quiz_attempts_export_data' ], -1 );
		add_action( 'admin_init', [ $self, 'students_export_data' ], -1 );
		add_action( 'admin_init', [ $self, 'instructors_export_data' ], -1 );
	}

	public function quiz_export_data() {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$exportType = isset( $_GET['exportType'] ) ? sanitize_text_field( $_GET['exportType'] ) : '';
		if ( 'academy-tools' !== $page || 'quizzes' !== $exportType || ! current_user_can( 'manage_options' ) ) {
			return false;
		}
		// Verify nonce
		check_admin_referer( 'academy_nonce', 'security' );

		$QuizExport = new QuizExport();
		// Start Exporting
		$csv_data = $QuizExport->get_quizzes_for_export();
		if ( ! count( $csv_data ) ) {
			return false;
		}
		$filename = 'academy-' . $exportType;
		$filename .= '.' . gmdate( 'Y-m-d' ) . '.csv';
		$QuizExport->array_to_csv_download(
			$csv_data,
			$filename,
			false
		);
		exit();
	}

	public function quiz_attempts_export_data() {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$path = isset( $_GET['path'] ) ? sanitize_text_field( $_GET['path'] ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$exportType = isset( $_GET['exportType'] ) ? sanitize_text_field( $_GET['exportType'] ) : '';
		if ( 'academy-quizzes' !== $page || 'quiz_attempts' !== $exportType || 'attempts' !== $path || ! current_user_can( 'manage_options' ) ) {
			return false;
		}
		// Verify nonce
		check_admin_referer( 'academy_nonce', 'security' );

		$QuizExport = new QuizAttemptExport();
		// Start Exporting
		$csv_data = $QuizExport->get_quiz_attempts_for_export();
		if ( ! count( $csv_data ) ) {
			return false;
		}
		$filename = 'academy-' . $exportType;
		$filename .= '.' . gmdate( 'Y-m-d' ) . '.csv';
		$QuizExport->array_to_csv_download(
			$csv_data,
			$filename,
			false
		);
		exit();
	}

	public function students_export_data() {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$exportType = isset( $_GET['exportType'] ) ? sanitize_text_field( $_GET['exportType'] ) : '';
		if ( 'academy-students' !== $page || 'students' !== $exportType || ! current_user_can( 'manage_options' ) ) {
			return false;
		}
		// Verify nonce
		check_admin_referer( 'academy_nonce', 'security' );

		$StudentExport = new StudentsExport();
		// Start Exporting
		$csv_data = $StudentExport->get_students_for_export();
		if ( ! count( $csv_data ) ) {
			return false;
		}
		$filename = 'academy-' . $exportType;
		$filename .= '.' . gmdate( 'Y-m-d' ) . '.csv';
		$StudentExport->array_to_csv_download(
			$csv_data,
			$filename,
			false
		);
		exit();
	}

	public function instructors_export_data() {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$page = isset( $_GET['page'] ) ? sanitize_text_field( $_GET['page'] ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$exportType = isset( $_GET['exportType'] ) ? sanitize_text_field( $_GET['exportType'] ) : '';
		if ( 'academy-instructors' !== $page || 'instructor-data-export' !== $exportType || ! current_user_can( 'manage_options' ) ) {
			return false;
		}
		// Verify nonce
		check_admin_referer( 'academy_nonce', 'security' );

		$InstructorsExport = new InstructorsExport();
		// Start Exporting
		$csv_data = $InstructorsExport->get_instructors_for_export();
		if ( ! count( $csv_data ) ) {
			return false;
		}
		$filename = 'academy-' . $exportType;
		$filename .= '.' . gmdate( 'Y-m-d' ) . '.csv';
		$InstructorsExport->array_to_csv_download(
			$csv_data,
			$filename,
			false
		);
		exit();
	}
}
