<?php
namespace AcademyPro\Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use AcademyPro\Classes;
use Academy\Classes\Sanitizer;
use Academy\Classes\AbstractAjaxHandler;

class Duplicate extends AbstractAjaxHandler {
	protected $namespace = ACADEMY_PLUGIN_SLUG . '_pro';
	public function __construct() {
		$this->actions = array(
			'duplicate_course' => array(
				'callback'   => array( $this, 'duplicate_course' ),
				'capability' => 'manage_academy_instructor',
			),
			'duplicate_lesson' => array(
				'callback'  => array( $this, 'duplicate_lesson' ),
				'capability' => 'manage_academy_instructor',
			),
			'duplicate_quiz' => array(
				'callback'  => array( $this, 'duplicate_quiz' ),
				'capability' => 'manage_academy_instructor',
			),
			'duplicate_assignment' => array(
				'callback'  => array( $this, 'duplicate_assignment' ),
				'capability' => 'manage_academy_instructor',
			),
		);
	}

	public function duplicate_course( $payload_data ) {
		$payload = Sanitizer::sanitize_payload( [
			'name' => 'string',
			'course_id' => 'integer'
		], $payload_data );

		$name = isset( $payload['name'] ) ? $payload['name'] : '';
		$course_id = isset( $payload['course_id'] ) ? $payload['course_id'] : 0;
		if ( ! $course_id ) {
			wp_send_json_error( __( 'Course ID is required.', 'academy-pro' ) );
		}

		$posts = get_post( $course_id );
		$duplicate_post = array(
			'post_author' => get_current_user_id(),
			'post_status' => 'draft',
			'post_title' => $posts->post_title . ' (copy)',
			'comment_status' => $posts->comment_status,
			'ping_status' => $posts->ping_status,
			'post_type' => $posts->post_type,
			'post_content' => $posts->post_content,
			'post_excerpt' => $posts->post_excerpt,
			'post_password' => $posts->post_password,
			'post_name' => sanitize_title( $posts->post_name . ' (copy)', 'untitled-course' ),
			'to_ping' => $posts->to_ping,
			'pinged' => $posts->pinged,
			'post_content_filtered' => $posts->post_content_filtered,
			'guid' => $posts->guid,
			'menu_order' => $posts->menu_order,
			'post_mime_type' => $posts->post_mime_type,
			'comment_count' => 0,
		);
		// update post
		$duplicate_id = wp_insert_post( $duplicate_post );
		if ( $duplicate_id ) {
			add_user_meta( get_current_user_id(), 'academy_instructor_course_id', $duplicate_id );
			$Duplicate = new Classes\Duplicate();
			// update post slug
			$Duplicate->update_course_slug( $course_id, $duplicate_id );
			// update post meta
			$Duplicate->update_course_post_meta( $course_id, $duplicate_id );
			// duplicate taxonomy
			$Duplicate->course_taxonomy_update( $course_id, $duplicate_id, 'academy_courses_category' );
			$Duplicate->course_taxonomy_update( $course_id, $duplicate_id, 'academy_courses_tag' );

			// duplicate course curriculum
			if ( 'academy-curriculum' === $name ) {
				$Duplicate->duplicate_course_curriculum( $course_id, $duplicate_id );
				wp_send_json_success( __( 'Successfully Duplicate Course with Curriculum!', 'academy-pro' ) );
			}

			wp_send_json_success( __( 'Successfully Duplicate Course!', 'academy-pro' ) );
		}
		wp_send_json_error( __( 'Sorry, Failed To Duplicate Course!', 'academy-pro' ) );
	}
	public function duplicate_lesson( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			'lesson_id' => 'integer',
		], $payload_data );

		$lesson_id = isset( $payload['lesson_id'] ) ? $payload['lesson_id'] : 0;
		if ( ! $lesson_id ) {
			return;
		}
		// get lesson data
		$lesson = \Academy\Helper::get_lesson( $lesson_id );
		$Duplicate = new Classes\Duplicate();

		// insert duplicate lesson data
		$new_lesson_id = $Duplicate->duplicate_lesson_insert( $lesson );
		if ( $new_lesson_id ) {
			$new_lesson_id = $Duplicate->duplicate_lesson_meta_insert( $lesson_id, $new_lesson_id );
			wp_send_json_success( __( 'Successfully Duplicate Lesson!', 'academy-pro' ) );
		}
		wp_send_json_error( __( 'Sorry, Failed To Duplicate Lesson!', 'academy-pro' ) );
	}
	public function duplicate_quiz( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			'quiz_id' => 'integer',
		], $payload_data );

		$quiz_id = isset( $payload['quiz_id'] ) ? $payload['quiz_id'] : 0;
		if ( ! $quiz_id ) {
			wp_send_json_error( __( 'Quiz ID is required.', 'academy-pro' ) );
		}
		// get quiz and insert duplicate quiz
		$Duplicate = new Classes\Duplicate();
		$new_quiz_id = $Duplicate->duplicate_quiz( $quiz_id );
		if ( isset( $new_quiz_id ) ) {
			$Duplicate->duplicate_quiz_meta( $quiz_id, $new_quiz_id );
			$questions = \AcademyQuizzes\Classes\Query::get_questions_by_quid_id( $quiz_id );
			foreach ( $questions as $question ) {
				$new_question_id = \AcademyQuizzes\Classes\Query::quiz_question_insert(array(
					'quiz_id'               => $new_quiz_id,
					'question_title'        => $question->question_title,
					'question_name'         => $question->question_name,
					'question_content'      => $question->question_content,
					'question_level'        => $question->question_level,
					'question_type'         => $question->question_type,
					'question_score'        => $question->question_score,
					'question_settings'     => $question->question_settings,
					'question_order'        => $question->question_order,
				));
				$answers = $Duplicate->get_quiz_answers_by_question_id( $question->question_id, $question->question_type );
				if ( $answers ) {
					$Duplicate->duplicate_quiz_answer_insert( $new_quiz_id, $new_question_id, $answers, $question->question_type );
				}
			}
			wp_send_json_success( __( 'Successfully Duplicate Quiz!', 'academy-pro' ) );
		}//end if
		wp_send_json_error( __( 'Sorry, Failed To Duplicate Quiz!', 'academy-pro' ) );
	}
	public function duplicate_assignment( $payload_data ) {
		$payload = Sanitizer::sanitize_payload( [
			'assignment_id' => 'integer',
		], $payload_data );
		$assignment_id = isset( $payload['assignment_id'] ) ? $payload['assignment_id'] : 0;
		if ( ! $assignment_id ) {
			wp_send_json_error( __( 'Assignment ID is required.', 'academy-pro' ) );
		}
		$posts = get_post( $assignment_id );
		$duplicate_post = array(
			'post_author' => get_current_user_id(),
			'post_status' => 'draft',
			'post_title' => $posts->post_title . ' (copy)',
			'comment_status' => $posts->comment_status,
			'ping_status' => $posts->ping_status,
			'post_type' => $posts->post_type,
			'post_content' => $posts->post_content,
			'post_excerpt' => $posts->post_excerpt,
			'post_password' => $posts->post_password,
			'post_name' => sanitize_title( $posts->post_name . ' (copy)', 'untitled-course' ),
			'to_ping' => $posts->to_ping,
			'pinged' => $posts->pinged,
			'post_content_filtered' => $posts->post_content_filtered,
			'guid' => $posts->guid,
			'menu_order' => $posts->menu_order,
			'post_mime_type' => $posts->post_mime_type,
			'comment_count' => 0,
		);

		$duplicate_id = wp_insert_post( $duplicate_post );
		if ( $duplicate_id ) {
			$meta_keys = [
				'academy_assignment_attachment',
				'academy_assignment_settings',
				'academy_assignment_enable_resubmit',
				'academy_assignment_resubmit_limit',
			];

			foreach ( $meta_keys as $key ) {
				$value = get_post_meta( $assignment_id, $key, true );
				update_post_meta( $duplicate_id, $key, $value );
			}
			wp_send_json_success( __( 'Successfully Duplicate Assignment!', 'academy-pro' ) );
		}//end if
		wp_send_json_error( __( 'Sorry, Failed To Duplicate Assignment!', 'academy-pro' ) );
	}

}
