<?php
namespace  AcademyPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Miscellaneous {
	public static function init() {
		$self = new self();
		// public course
		add_filter( 'academy/is_public_course', array( $self, 'is_public_course' ), 10, 2 );
		add_action( 'before_delete_post', array( $self, 'restrict_academy_pro_post_type_deletion' ) );
	}
	public function is_public_course( $status, $course_type ) {
		if ( 'public' === $course_type ) {
			return true;
		}
		return $status;
	}
	public function restrict_academy_pro_post_type_deletion( $post_id ) {
		$post = get_post( $post_id );
		$post_types = [
			'academy_assignments',
			'alms_course_bundle',
			'academy_meeting',
			'academy_booking',
		];
		if ( in_array( $post->post_type, $post_types, true ) && get_current_user_id() !== (int) $post->post_author && ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'You are not allowed to delete this post.', 'academy-pro' ) );
		}
	}
}
