<?php
/**
 * @license Apache-2.0
 *
 * Modified by academy-pro on 23-October-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

if (class_exists('AcademyPro_Google_Client', false)) {
    // Prevent error with preloading in PHP 7.4
    // @see https://github.com/googleapis/google-api-php-client/issues/1976
    return;
}

$classMap = [
    'AcademyPro\\Google\\Client' => 'AcademyPro_Google_Client',
    'AcademyPro\\Google\\Service' => 'AcademyPro_Google_Service',
    'AcademyPro\\Google\\AccessToken\\Revoke' => 'AcademyPro_Google_AccessToken_Revoke',
    'AcademyPro\\Google\\AccessToken\\Verify' => 'AcademyPro_Google_AccessToken_Verify',
    'AcademyPro\\Google\\Model' => 'AcademyPro_Google_Model',
    'AcademyPro\\Google\\Utils\\UriTemplate' => 'AcademyPro_Google_Utils_UriTemplate',
    'AcademyPro\\Google\\AuthHandler\\Guzzle6AuthHandler' => 'AcademyPro_Google_AuthHandler_Guzzle6AuthHandler',
    'AcademyPro\\Google\\AuthHandler\\Guzzle7AuthHandler' => 'AcademyPro_Google_AuthHandler_Guzzle7AuthHandler',
    'AcademyPro\\Google\\AuthHandler\\AuthHandlerFactory' => 'AcademyPro_Google_AuthHandler_AuthHandlerFactory',
    'AcademyPro\\Google\\Http\\Batch' => 'AcademyPro_Google_Http_Batch',
    'AcademyPro\\Google\\Http\\MediaFileUpload' => 'AcademyPro_Google_Http_MediaFileUpload',
    'AcademyPro\\Google\\Http\\REST' => 'AcademyPro_Google_Http_REST',
    'AcademyPro\\Google\\Task\\Retryable' => 'AcademyPro_Google_Task_Retryable',
    'AcademyPro\\Google\\Task\\Exception' => 'AcademyPro_Google_Task_Exception',
    'AcademyPro\\Google\\Task\\Runner' => 'AcademyPro_Google_Task_Runner',
    'AcademyPro\\Google\\Collection' => 'AcademyPro_Google_Collection',
    'AcademyPro\\Google\\Service\\Exception' => 'AcademyPro_Google_Service_Exception',
    'AcademyPro\\Google\\Service\\Resource' => 'AcademyPro_Google_Service_Resource',
    'AcademyPro\\Google\\Exception' => 'AcademyPro_Google_Exception',
];

foreach ($classMap as $class => $alias) {
    class_alias($class, $alias);
}

/**
 * This class needs to be defined explicitly as scripts must be recognized by
 * the autoloader.
 */
class AcademyPro_Google_Task_Composer extends \AcademyPro\Google\Task\Composer
{
}

/** @phpstan-ignore-next-line */
if (\false) {
    class AcademyPro_Google_AccessToken_Revoke extends \AcademyPro\Google\AccessToken\Revoke
    {
    }
    class AcademyPro_Google_AccessToken_Verify extends \AcademyPro\Google\AccessToken\Verify
    {
    }
    class AcademyPro_Google_AuthHandler_AuthHandlerFactory extends \AcademyPro\Google\AuthHandler\AuthHandlerFactory
    {
    }
    class AcademyPro_Google_AuthHandler_Guzzle6AuthHandler extends \AcademyPro\Google\AuthHandler\Guzzle6AuthHandler
    {
    }
    class AcademyPro_Google_AuthHandler_Guzzle7AuthHandler extends \AcademyPro\Google\AuthHandler\Guzzle7AuthHandler
    {
    }
    class AcademyPro_Google_Client extends \AcademyPro\Google\Client
    {
    }
    class AcademyPro_Google_Collection extends \AcademyPro\Google\Collection
    {
    }
    class AcademyPro_Google_Exception extends \AcademyPro\Google\Exception
    {
    }
    class AcademyPro_Google_Http_Batch extends \AcademyPro\Google\Http\Batch
    {
    }
    class AcademyPro_Google_Http_MediaFileUpload extends \AcademyPro\Google\Http\MediaFileUpload
    {
    }
    class AcademyPro_Google_Http_REST extends \AcademyPro\Google\Http\REST
    {
    }
    class AcademyPro_Google_Model extends \AcademyPro\Google\Model
    {
    }
    class AcademyPro_Google_Service extends \AcademyPro\Google\Service
    {
    }
    class AcademyPro_Google_Service_Exception extends \AcademyPro\Google\Service\Exception
    {
    }
    class AcademyPro_Google_Service_Resource extends \AcademyPro\Google\Service\Resource
    {
    }
    class AcademyPro_Google_Task_Exception extends \AcademyPro\Google\Task\Exception
    {
    }
    interface AcademyPro_Google_Task_Retryable extends \AcademyPro\Google\Task\Retryable
    {
    }
    class AcademyPro_Google_Task_Runner extends \AcademyPro\Google\Task\Runner
    {
    }
    class AcademyPro_Google_Utils_UriTemplate extends \AcademyPro\Google\Utils\UriTemplate
    {
    }
}
