<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$button_text = $is_free ? __( 'Enroll Now', 'academy-pro' ) : __( 'Add to Cart', 'academy-pro' );
?>
<div class="academy-widget-enroll__prerequisite" id="prerequisite-message">
	<div class="academy-archive-prerequisite">	
		<p class="academy-prerequisites-message"><?php esc_html_e( 'NOTE: Complete prerequisite courses to begin this.', 'academy-pro' ); ?></p>
		<ul class="academy-prerequisites-lists">
			<?php
			foreach ( $required_courses as $course_id ) :
				?>
			<li><a href="<?php echo esc_url( get_permalink( $course_id ) ); ?>"><?php echo esc_html( get_the_title( $course_id ) ); ?></a></li>
				<?php
				endforeach;
			?>
		</ul>
	</div>
</div>
<!-- here is button text -->
<button 
	type="button" 
	class="academy-enroll-form__prerequisite academy-btn academy-btn--bg-purple toggle-password academy-icon academy-icon--lock" 
	id="enroll-prerequisite-btn"
>
	<?php echo esc_html( $button_text ); ?>
</button>

