<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_user_logged_in() ) {
	\Academy\Helper::get_template( 'curriculums/partial/login-alert.php', array( 'message' => __( 'Log in to Participate And Submit Assignments.', 'academy-pro' ) ) );
	return;
}

$assignment = \AcademyProAssignments\Helper::render_assignment_for_php_rendering( $course_id, $assignment_id );
$submitted_assignment = $assignment->submitted_assignment ?? '';
$assignment_status = $submitted_assignment->comment_approved ?? '';
$submission_time = $assignment->settings['submission_time'];
$remaining_time = 0;
if ( 'submitting' === $assignment_status && $submission_time > 0 ) {
	$remaining_time = \AcademyProAssignments\Helper::get_the_remaining_time_of_an_assignment_in_php_render( $submitted_assignment->comment_date_gmt, $submission_time, $assignment );
}
$is_update = isset( $_GET['update'] ) ? sanitize_text_field( wp_unslash( $_GET['update'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
$is_resubmitted = isset( $_GET['resubmit'] ) ? sanitize_text_field( wp_unslash( $_GET['resubmit'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
?>

<div class="academy-assignment-content">
	<h4><?php echo esc_html( $assignment->post_title ); ?></h4>
	<div class="academy-assignment-content__wrapper">
		<?php

			$default_template_path = array(
				'curriculums/assignment/header.php',
				( 'submitted' !== $assignment_status && 'pass' !== $assignment_status && 'failed' !== $assignment_status ) ? 'curriculums/assignment/description.php' : null,
				empty( $assignment_status ) ? 'curriculums/assignment/start.php' : null,
				( 'submitting' === $assignment_status && 1 !== $remaining_time->invert ) ? 'curriculums/assignment/submission-form.php' : ( ( ! empty( $remaining_time ) && 1 === $remaining_time->invert ) ? 'curriculums/assignment/time-expired.php' : null ),
				( 'submitted' === $assignment_status || 'pass' === $assignment_status || 'failed' === $assignment_status ) ? 'curriculums/assignment/attempt.php' : null
			);

			$default_template_args = array(
				'course_id'     => $course_id,
				'assignment_id' => $assignment_id,
			);

			$default_template_path = ( $is_update ) ? array( 'curriculums/assignment/update-assignment.php' ) : ( ( $is_resubmitted ) ? [ 'curriculums/assignment/resubmit-assignment.php' ] : array_filter( $default_template_path ) );

			foreach ( $default_template_path as $template_path ) {
				\AcademyPro\Helper::get_template( $template_path, $default_template_args );
			}

			?>
	</div>
</div>
