<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$assignment = \AcademyProAssignments\Helper::render_assignment_for_php_rendering( $course_id, $assignment_id );
$submitted_assignment = $assignment->submitted_assignment ?? '';
$submission_attempt = get_option( 'academy_pro_assignment_' . $submitted_assignment->comment_ID . '_submission_attempt' );
$submitted_assignment->has_permission_submitted = false;
if ( $submission_attempt < $submitted_assignment->academy_assignment_resubmit_limit ) {
	$submitted_assignment->has_permission_submitted = true;
}

?>
<div class="academy-assignment-content__body academy-assignment-content__wrapper">
	<div class="academy-assignment-content__attempt-details">
		<?php
			$template_paths = array( 'curriculums/assignment/attempt/details.php', 'curriculums/assignment/attempt/submitted.php' );
			$template_arg = array( 'submitted_assignment' => $submitted_assignment );

		foreach ( $template_paths as $template_path ) {
			\AcademyPro\Helper::get_template( $template_path, $template_arg );
		}
		?>
	</div>
</div>
