<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$assignment = \AcademyProAssignments\Helper::render_assignment_for_php_rendering( $course_id, $assignment_id );

?>

<div class="academy-assignment-content__details">
	<?php if ( ! empty( $assignment->post_content ) ) : ?>
	<div class="academy-assignment-content__details-top">
		<h5 class="academy-assignment-content__details-title">
			<?php echo esc_html__( 'Description :', 'academy-pro' ); ?>
		</h5>
		<?php
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo \Academy\Helper::get_content_html( stripslashes( $assignment->post_content ) );
		?>
	</div>
	<?php endif; ?>
	<div class="academy-assignment-content__details-bottom">
		<h5 class="academy-assignment-content__details-title">
			<?php echo esc_html__( 'Attachment :', 'academy-pro' ); ?>
		</h5>
		<?php if ( $assignment->attachment['ID'] ) : ?>
		<a class="academy-download-attachment" target="_blank" href="<?php echo esc_url( $assignment->attachment['url'] ); ?>" download>
			<p class="academy-download-attachment__name">
				<?php echo esc_html( $assignment->attachment['title'] ); ?>
			</p>
			<?php
			// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
			<img src="<?php echo esc_url( ACADEMY_ASSETS_URI . 'images/downloadAttachment.png' ); ?>"  alt="download_file"/>
		</a>
		<?php else : ?>
			<p class="academy-download-attachment__name">
				<?php echo esc_html__( 'Attachment not available!', 'academy-pro' ); ?>
			</p>
		<?php endif; ?>
	</div>
</div>
