<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_user_logged_in() ) {
	\Academy\Helper::get_template( 'curriculums/partial/login-alert.php', array( 'message' => __( 'Log in to Participate book Booking.', 'academy-pro' ) ) );
	return;
}

?>

<div 
	id="academy_curriculum_booking_content" 
	class="academy-curriculum-booking-content"
	data-course-id="<?php echo esc_attr( $course_id ); ?>" 
	data-booking-id="<?php echo esc_attr( $booking_id ); ?>" 
	data-calendar-settings="<?php echo esc_attr( wp_json_encode( $calendar_settings ) ); ?>" 
>
	<?php
		$preloader = apply_filters( 'academy/preloader', academy_get_preloader_html() );
		echo wp_kses_post( $preloader );
	?>
</div>
