<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$meeting = \AcademyProMeeting\Helper::render_meeting_for_php_rendering( $course_id, $meeting_id );

?>

<div class='academy-zoom-content__content-bottom'>
	<div class='academy-zoom-content__title'>
		<?php echo esc_html( $meeting['meetingTitle'] ); ?>
	</div>
	<div class="academy-zoom-content__description">
		<div class="academy-zoom-details__label">
			<?php echo esc_html( 'Meeting Description', 'academy-pro' ); ?>
		</div>
		<div class="academy-zoom-details__value">
			<?php echo esc_html( $meeting['meetingDescription'] ); ?>
		</div>
	</div>
	<div class="academy-zoom-content__meeting-date">
		<div class="academy-zoom-details__label">
			<?php echo esc_html__( 'Meeting Date', 'academy-pro' ); ?>
		</div>
		<div class="academy-zoom-details__value">
			<?php echo esc_html( gmdate( 'd F Y G:i:s A', strtotime( $meeting['meetingDate'] ) ) ); ?>
		</div>
	</div>
	<div class="academy-zoom-content__meeting-id">
		<div class="academy-zoom-details__label">
			<?php echo esc_html__( 'Meeting ID', 'academy-pro' ); ?>
		</div>
		<div class="academy-zoom-details__value">
			<?php echo esc_html( $meeting['meetingId'] ); ?>
		</div>
	</div>
</div>
