<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$meeting = \AcademyProMeeting\Helper::render_meeting_for_php_rendering( $course_id, $meeting_id );

$meeting_type = $meeting['meeting_type'];

$template_paths = array();
$template_args = array(
	'course_id' => $course_id,
	'meeting_id' => $meeting_id
);

if ( 'zoom' === $meeting_type ) {
	$template_paths = wp_parse_args( array( 'curriculums/meeting/zoom/timer.php', 'curriculums/meeting/zoom/details.php' ), $template_path );
} elseif ( 'google_meet' === $meeting_type ) {
	$template_paths = wp_parse_args( array( 'curriculums/meeting/google-meet/timer.php', 'curriculums/meeting/google-meet/details.php' ), $template_path );
}

foreach ( $template_paths as $template_path ) {
	\AcademyPro\Helper::get_template( $template_path, $template_args );
}


