<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$zoom = \AcademyProMeeting\Helper::render_meeting_for_php_rendering( $course_id, $meeting_id );
$remain_time = \AcademyProMeeting\Helper::reamining_time_before_meeting_depend_on_timezone( $zoom['start_time'], $zoom['timezone'] );
$ending_time = '';
if ( 1 === $remain_time->invert ) {
	$set_time = new DateTime( $zoom['start_time'], new DateTimeZone( $zoom['timezone'] ) );
	$set_time->add( new DateInterval( "PT{$zoom['duration']}M" ) );
	$ending_time = $set_time->format( 'Y-m-d\TH:i:s' );

	$ending_time = \AcademyProMeeting\Helper::remaining_after_meeting_start_depend_on_time_zone(
		$ending_time, // pass string instead
		$zoom['timezone']
	);
}
?>

<div class="academy-zoom-content__content-top">
	<?php if ( 1 !== $remain_time->invert ) : ?>
		<h3>
			<?php echo esc_html__( 'Meeting starts in', 'academy-pro' ); ?>
		</h3>
		<span class="academy-quiz-timer">
			<div class="academy-zoom-schedule__time">
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $remain_time->d ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'days', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $remain_time->h ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'hours', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $remain_time->i ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'minutes', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $remain_time->s ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'seconds', 'academy-pro' ); ?>
					</span>
				</div>
			</div>
		</span>
		<div class="academy-zoom-schedule__buttons">
			<a href="<?php echo esc_url( $zoom['start_url'] ); ?>" class="academy-btn-zoom" target="_blank">
				<span class="academy-btn--label">
					<?php echo esc_html__( 'Start Meeting', 'academy-pro' ); ?>
				</span>
				<span class="academy-icon academy-icon--go-on"></span>
			</a>
			<a href="<?php echo esc_url( $zoom['join_url'] ); ?>" class="academy-btn-zoom" target="_blank">
				<span class="academy-btn--label">
					<?php echo esc_html__( 'Join in the zoom app', 'academy-pro' ); ?>
				</span>
				<span class="academy-icon academy-icon--go-on"></span>
			</a>
		</div>
	<?php elseif ( 1 !== $ending_time->invert ) : ?>
		<h3>
			<?php echo esc_html__( 'Meeting Ends in', 'academy-pro' ); ?>
		</h3>
		<span class="academy-quiz-timer">
			<div class="academy-zoom-schedule__time">
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $ending_time->d ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'days', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $ending_time->h ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'hours', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $ending_time->i ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'minutes', 'academy-pro' ); ?>
					</span>
				</div>
				<div class="academy-zoom-schedule__details">
					<span class="academy-time__value">
						<?php echo esc_html( $ending_time->s ); ?>
					</span>
					<span class="academy-time__unit">
						<?php echo esc_html__( 'seconds', 'academy-pro' ); ?>
					</span>
				</div>
			</div>
		</span>
		<div class="academy-zoom-schedule__buttons">
			<a href="<?php echo esc_url( $zoom['join_url'] ); ?>" class="academy-btn-zoom" target="_blank">
				<span class="academy-btn--label">
					<?php echo esc_html__( 'Join in the zoom app', 'academy-pro' ); ?>
				</span>
				<span class="academy-icon academy-icon--go-on"></span>
			</a>
		</div>
	<?php else : ?>
		<div class="academy-zoom-content--expire">
			<span class="academy-icon academy-icon--information"></span>
			<span>
				<?php echo esc_html__( 'This meeting is Expired. To get more information about this meeting, contact the instructor.', 'academy-pro' ); ?>
			</span>
		</div>
	<?php endif; ?>
</div>
