<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="academy-certificate-verify">
	<h1 class="academy-certificate-verify__title"><?php esc_html_e( 'Verify Your Certificate', 'academy-pro' ); ?></h1>
	<p class="academy-certificate-verify__subtitle"><?php esc_html_e( 'Verify the authenticity and integrity of your certificate', 'academy-pro' ); ?></p>
	<img src="<?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
	echo esc_url( ACADEMY_PRO_ASSETS_URI . 'images/Certificate.svg' ); ?>" alt="certificate" class="academy-certificate-verify__thumbnail">
	<form id="academy-certificate-verify__form" action="#">
		<div class="academy-certificate-verify__form-input">
			<span class="academy-certificate-verify__form-input-title"><?php esc_html_e( 'Certificate Number', 'academy-pro' ); ?></span>
			<input type="text" name="certificate_id" placeholder="Ex. 124E345456B3" required>
		</div>
		<div class="academy-certificate-verify__append-error-content"></div>
		<button class="academy-btn academy-certificate-verify__form-submit" type="submit" value="Verify">
			<?php esc_html_e( 'Verify Certificate', 'academy-pro' ); ?>
		</button>
		<div class="academy-certificate-verify__append-success-content"></div>
	</form>
</div>
