<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="academy-social-login">
	<?php if ( $is_enabled_facebook_login || $is_enabled_google_login ) : ?>
		<?php if ( $show_divider ) : ?>
			<div class="academy-social-login__divider">OR</div>
		<?php endif; ?>
	<?php endif; ?>
	<div class="academy-social-login__status"></div>
	<?php if ( true === $is_enabled_facebook_login ) : ?>
	<button class="academy-social-login__facebook" 
		data-appId="<?php echo esc_attr( \Academy\Helper::get_settings( 'facebook_app_id' ) ); ?>"
		data-isRegister="<?php echo esc_attr( $is_register ); ?>"
	><svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs/>
	<path id="Vector" d="M8.49 0C3.82 0 0 3.84 0 8.53C0 12.74 3.11 16.24 7.13 16.98L7.13 10.92L5.01 10.92L5.01 8.53L7.13 8.53L7.13 6.65C7.13 4.52 8.49 3.32 10.44 3.32C11.03 3.32 11.71 3.41 12.31 3.49L12.31 5.67L11.2 5.67C10.18 5.67 9.93 6.18 9.93 6.87L9.93 8.53L12.18 8.53L11.8 10.92L9.93 10.92L9.93 16.97C13.94 16.23 16.98 12.74 16.98 8.53C16.98 3.84 13.16 0 8.49 0Z" fill="#4285F4" fill-opacity="1.000000" fill-rule="nonzero"/>
	</svg>Sign in with Facebook</button>
	<?php endif; ?>
	<?php if ( true === $is_enabled_google_login ) : ?>
	<div 
		id="academy-social-google-login" 
		class="academy-social-login__google" 
		data-clientId="<?php echo esc_attr( \Academy\Helper::get_settings( 'google_client_id' ) ); ?>"
		data-isRegister="<?php echo esc_attr( $is_register ); ?>"
		data-role="<?php echo esc_attr( $role ); ?>"
	></div>
	<?php endif; ?>
</div>
