<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( empty( $courses ) ) {
	return;
}

?>

<div id="academylms-courses-table" class="table-wrapper"></div>
<table class="table table-striped">
	<thead>
	<tr>
		<th>
			<?php esc_html_e( 'Courses', 'academy-pro' ); ?>
			<?php wishlistmember_instance()->tooltip( __( 'The Courses from the academylms LMS > Courses section.', 'academy-pro' ) ); ?>
		</th>
		<th width="1%"><?php echo esc_html( 'Action' ); ?></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $courses as $course_id => $course ) : ?>
		<tr>
			<td><a href="#" data-toggle="modal" data-target="#academylms-course-<?php echo esc_attr( $course_id ); ?>"><?php echo esc_html( $course['title'] ); ?></a></td>
			<td>
				<div class="btn-group-action">
					<a href="#" data-toggle="modal" data-target="#academylms-course-<?php echo esc_attr( $course_id ); ?>" class="btn -courses-btn" title="Edit Actions"><i class="wlm-icons md-24"><?php echo esc_html( 'edit' ); ?></i></a>
				</div>
			</td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>

