<?php

if ( ! defined( 'ABSPATH' ) ) {
	return;
}

?>

<div id="academylms-levels-table" class="table-wrapper"></div>
<script type="text/template" id="academylms-levels-template">
	<table class="table table-striped">
		<thead>
		<tr>
			<th><?php echo esc_html__( 'Membership Level', 'academy-pro' ); ?></th>
			<th width="1%"><?php echo esc_html__( 'Action', 'academy-pro' ); ?></th>
		</tr>
		</thead>
		<tbody>
		{% _.each(data.levels, function(level) { %}
		<tr>
			<td><a href="#" data-toggle="modal" data-target="#academylms-levels-{%- level.id %}">{%= level.name %}</a></td>
			<td>
				<div class="btn-group-action">
					<a href="#" data-toggle="modal" data-target="#academylms-levels-{%- level.id %}" class="btn -levels-btn" title="Edit Actions"><i class="wlm-icons md-24"><?php echo esc_html( 'edit' ); ?></i></a>
				</div>
			</td>
		</tr>
		{% }); %}
		</tbody>
	</table>
</script>


<script type="text/javascript">
	$('#academylms-levels-table').empty();
	// all levels defined in the wishlist member own code
	$.each(all_levels, function(k, v) {
		var data = {
			levels : v
		}
		var tmpl = _.template($('script#academylms-levels-template').html(), {variable: 'data'});
		var html = tmpl(data);
		$('#academylms-levels-table').append(html);
		return false;
	});
</script>
