<?php
/**
 * User Payment
 *
 * @package     AutomatorWP\Integrations\Easy_Affiliate\Triggers\User Payment
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Easy_Affiliate_User_Payment extends AutomatorWP_Integration_Trigger {

    public $integration = 'easy_affiliate';
    public $trigger = 'easy_affiliate_user_payment';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User gets a payment', 'automatorwp-pro' ),
            'select_option'     => __( 'User gets a <strong>payment</strong', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User gets a payment %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            /* translators: %1$s: Tag. */
            'log_label'         => __( 'User gets a payment', 'automatorwp-pro' ),
            'action'            => 'esaf_event_payment-added',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array $args       Args from Easy Affiliate event
     */
    public function listener( $args ) {

        $user_id = get_current_user_id();

        // Bail if no user
        if ( absint( $user_id ) === 0 ) {
            return;
        }
       
        // Trigger the user added as affiliate
        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
        ) );

    }

}

new AutomatorWP_Easy_Affiliate_User_Payment();