<?php
/**
 * Plugin Name:           AutomatorWP - Generator
 * Plugin URI:            https://automatorwp.com/add-ons/generator/
 * Description:           Connect AutomatorWP with Generator.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-generator
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Generator
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Generator {

    /**
     * @var         AutomatorWP_Generator $instance The one true AutomatorWP_Generator
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Generator self::$instance The one true AutomatorWP_Generator
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Generator();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_GENERATOR_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_GENERATOR_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_GENERATOR_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_GENERATOR_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/tags.php';

            // Actions
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/actions/generate-hash.php';
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/actions/generate-nonce.php';
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/actions/generate-number.php';
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/actions/generate-string.php';
            require_once AUTOMATORWP_GENERATOR_DIR . 'includes/actions/generate-email.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'generator', array(
            'label' => 'Generator',
            'icon'  => AUTOMATORWP_GENERATOR_URL . 'assets/generator.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Generator instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Generator The one true AutomatorWP_Generator
 */
function AutomatorWP_Generator() {
    return AutomatorWP_Generator::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Generator' );
