<?php
/**
 * User Field
 *
 * @package     AutomatorWP\Integrations\iMember360\Actions\User_Field
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_iMember360_User_Field extends AutomatorWP_Integration_Action {

    public $integration = 'imember360';
    public $action = 'imember360_user_field';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Set user contact field value', 'automatorwp-pro' ),
            'select_option'     => __( 'Set user contact <strong>field value</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Value. %2$s: Field. */
            'edit_label'        => sprintf( __( 'Set value %1$s for user contact field %2$s', 'automatorwp-pro' ), '{value}', '{field}' ),
            /* translators: %1$s: Value. %2$s: Field. */
            'log_label'         => sprintf( __( 'Set value %1$s for user contact field %2$s', 'automatorwp-pro' ), '{value}', '{field}' ),
            'options'           => array(
                'value' => array(
                    'from' => 'value',
                    'default' => __( 'value', 'automatorwp-pro' ),
                    'fields' => array(
                        'value' => array(
                            'name' => __( 'Value:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        )
                    )
                ),
                'field' => array(
                    'from' => 'field',
                    'default' => __( 'field', 'automatorwp-pro' ),
                    'fields' => array(
                        'field' => array(
                            'name' => __( 'Field:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'classes' => 'automatorwp-selector',
                            'options_cb' => array( $this, 'fields_options_cb' ),
                            'default' => ''
                        )
                    )
                ),
            ),
        ) );

    }

    /**
     * Get fields options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function fields_options_cb() {

        global $i4w;

        $options = array();

        // Get site contact fields
        if ( ! empty( $i4w->dbsFIELDS ) ) {
            foreach ( $i4w->dbsFIELDS AS $field_name => $field_label ) {
                $options[$field_name] = $field_label;
            }
        }

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $SESSION;

        // Shorthand
        $field = $action_options['field'];
        $value = $action_options['value'];

        // get the user contact ID
        $remote_logged_in = $SESSION['DBSHORT']['id'];

        IF ( empty( $remote_logged_in ) ) {
            $remote_logged_in = get_user_meta( $user_id, 'imember360_user_id', true );
        }

        // Bail if can't get the contact ID
        IF ( empty( $remote_logged_in ) ) {
            return;
        }

        // Update user field
        $GLOBALS['i4w']->myApp->updateCon( $remote_logged_in, array( $field => $value ) );

    }

}

new AutomatorWP_iMember360_User_Field();