<?php
/**
 * Contact Added
 *
 * @package     AutomatorWP\Integrations\Jetpack_CRM\Triggers\Contact_Added
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Jetpack_CRM_Contact_Added extends AutomatorWP_Integration_Trigger {

    public $integration = 'jetpack_crm';
    public $trigger = 'jetpack_crm_contact_added';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'New contact is added', 'automatorwp-pro' ),
            'select_option'     => __( 'New contact is <strong>added</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: List. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'New contact is added %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            /* translators: %1$s: List. */
            'log_label'         => __( 'New contact is added', 'automatorwp-pro' ),
            'action'            => 'zbs_new_customer',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_jetpack_crm_get_contact_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array $obj
     */
    public function listener( $obj ) {

        $user_id = get_current_user_id( );

        // Bail if not user
        if ( $user_id === 0 ) {
            return;
        }

        // To get the contact data
        $contact_data = zeroBS_getCustomer( $obj );

        // Trigger the contact added
        automatorwp_trigger_event( array(
            'trigger'               => $this->trigger,
            'user_id'               => $user_id,
            'contact_first_name'    => $contact_data['fname'],
            'contact_last_name'     => $contact_data['lname'],
            'contact_email'         => $contact_data['email']
        ) );
        

    }

    /**
     * Register the required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_trigger_log_meta', array( $this, 'log_meta' ), 10, 6 );

        parent::hooks();
    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['contact_first_name'] = ( isset( $event['contact_first_name'] ) ? $event['contact_first_name'] : '' );
        $log_meta['contact_last_name'] = ( isset( $event['contact_last_name'] ) ? $event['contact_last_name'] : '' );
        $log_meta['contact_email'] = ( isset( $event['contact_email'] ) ? $event['contact_email'] : '' );

        return $log_meta;

    }    

}

new AutomatorWP_Jetpack_CRM_Contact_Added();