<?php
/**
 * Mark Lesson
 *
 * @package     AutomatorWP\Integrations\MasterStudy_LMS\Actions\Mark_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_MasterStudy_LMS_Mark_Lesson extends AutomatorWP_Integration_Action {

    public $integration = 'masterstudy_lms';
    public $action = 'masterstudy_lms_mark_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark lesson as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>lesson as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => array(
                    'from' => 'post',
                    'default' => __( 'lesson', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'post_type'         => 'stm-courses',
                        ) ),
                        'course_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                        ) ),
                        'post' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Lesson:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a lesson', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                            'post_type'         => 'stm-lessons',
                        ) ),
                        'post_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                        ) ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $lesson_id = absint( $action_options['post'] );
        $course_id = absint( $action_options['course'] );

        // Bail if not lesson not provided
        if( $lesson_id === 0 ) {
            return;
        }

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        // Bail if lesson already completed
        if ( STM_LMS_Lesson::is_lesson_completed( $user_id, $course_id, $lesson_id ) ) {
            return;
        }

        $end_time = time();
        $start_time = get_user_meta( $user_id, "stm_lms_course_started_{$course_id}_{$lesson_id}", true );
        $user_lesson = compact( 'user_id', 'course_id', 'lesson_id', 'start_time', 'end_time' );

        // Mark lesson as completed
        stm_lms_add_user_lesson( $user_lesson );
        STM_LMS_Course::update_course_progress( $user_id, $course_id );

        do_action( 'stm_lms_lesson_passed', $user_id, $lesson_id );

        delete_user_meta( $user_id, "stm_lms_course_started_{$course_id}_{$lesson_id}" );

    }

}

new AutomatorWP_MasterStudy_LMS_Mark_Lesson();