<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Modern_Events_Calendar\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting event tickets
 *
 * @since 1.0.0
 */
function automatorwp_modern_events_calendar_ajax_get_event_tickets() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? sanitize_text_field( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;
    $event_id = isset( $_REQUEST['event_id'] ) ? absint( $_REQUEST['event_id'] ) : 0;

    // Bail if not event ID provided
    if( $event_id === 0 ) {
        wp_send_json_success( array(
            array(
                'id' => '0',
                'text' => __( 'Please, choose an event first.', 'automatorwp-pro' )
            )
        ) );
        die;
    }

    $tickets = get_post_meta( $event_id, 'mec_tickets', true );

    // Bail if event does not have tickets
    if ( empty( $tickets ) ) {
        wp_send_json_success( array(
            array(
                'id' => '0',
                'text' => __( 'No tickets found for event selected.', 'automatorwp-pro' )
            )
        ) );
        die;
    }

    foreach ( $tickets as $ticket_id => $ticket ) {
        // If search provided, only return tickets that match with the search
        if( ! empty( $search ) ) {
            if( strpos( $ticket['name'], $search ) !== false ) {
                continue;
            }
        }

        $results[] = array(
            'id' => $ticket_id,
            'text'  => $ticket['name'],
        );
    }

    // Parse extra options
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_modern_events_calendar_get_event_tickets', 'automatorwp_modern_events_calendar_ajax_get_event_tickets' );