<?php
/**
 * New Conversation
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\New_Conversation
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_New_Conversation extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_new_conversation';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User starts a conversation', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>starts</strong> a conversation', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User starts a conversation %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User starts a conversation', 'automatorwp-pro' ),
            'action'            => 'gamipress_peepso_new_conversation',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $message_id The message ID
     */
    public function listener( $message_id ) {

        $user_id = absint( get_post_field( 'post_author', $message_id ) );

        // Trigger send friend request
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $user_id,
        ) );

    }

}

new AutomatorWP_PeepSo_New_Conversation();