<?php
/**
 * Complete Quiz Type
 *
 * @package     AutomatorWP\Integrations\Thrive_Quiz_Builder\Triggers\Complete_Quiz_Type
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Quiz_Builder_Complete_Quiz_Type extends AutomatorWP_Integration_Trigger {

    public $integration = 'thrive_quiz_builder';
    public $trigger = 'thrive_quiz_builder_complete_quiz_type';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User completes a quiz of a type', 'automatorwp-pro' ),
            'select_option'     => __( 'User completes a quiz of a <strong>type</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Quiz type. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User completes a quiz of %1$s %2$s time(s)', 'automatorwp-pro' ), '{types}', '{times}' ),
            /* translators: %1$s: Quiz type. */
            'log_label'         => sprintf( __( 'User completes of %1$s', 'automatorwp-pro' ), '{types}' ),
            'action'            => 'tqb_quiz_completed',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'types' => array(
                    'from' => 'types',
                    'default' => __( 'any type', 'automatorwp-pro' ),
                    'fields' => array(
                        'types' => array(
                            'name'              => __( 'Type:', 'automatorwp-pro' ),
                            'type'  => 'select',
                            'options_cb'        => 'automatorwp_thrive_quiz_builder_options_cb_quiz_types',
                            'classes' => 'automatorwp-selector',
                            'default' => 'any'
                    
                 ))),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param WP_Post   $quiz   Quiz data
     * @param array     $user   User data
     */
    public function listener( $quiz, $user ) {

        $user_id = get_current_user_id();
        $quiz_id = $quiz->ID;
        $quiz_type = $quiz->type;

        // Bail if is not a quiz
        if ( 'tqb_quiz' !== get_post_type( $quiz_id ) ) {
            return;
        }

        // Bail if not user
        if ( $user_id === 0) {
            return;
        }
        
        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $quiz_id,
            'quiz_type' => $quiz_type
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( $trigger_options['types'] != 'any' &&  $trigger_options['types'] != $event['quiz_type'] ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_Thrive_Quiz_Builder_Complete_Quiz_Type();