<?php
/**
 * Change Photo
 *
 * @package     AutomatorWP\Integrations\Ultimate_Member\Triggers\Change_Photo
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Ultimate_Member_Change_Photo extends AutomatorWP_Integration_Trigger {

    public $integration = 'ultimate_member';
    public $trigger = 'ultimate_member_change_photo';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User changes profile photo', 'automatorwp-pro' ),
            'select_option'     => __( 'User changes <strong>profile photo</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User changes profile photo %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User changes profile photo', 'automatorwp-pro' ),
            'action'            => 'um_after_upload_db_meta',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int       $user_id    The user ID
     * @param string    $key        The key of item uploaded ('profile_photo'|'cover_photo')
     */
    public function listener( $user_id, $key ) {

        if( $key !== 'profile_photo' ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_Ultimate_Member_Change_Photo();