<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Webhooks\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_webhooks_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-webhooks-admin-css', AUTOMATORWP_WEBHOOKS_URL . 'assets/css/automatorwp-webhooks-admin' . $suffix . '.css', array( ), AUTOMATORWP_WEBHOOKS_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-webhooks-admin-js', AUTOMATORWP_WEBHOOKS_URL . 'assets/js/automatorwp-webhooks-admin' . $suffix . '.js', array( 'jquery', 'jquery-ui-dialog' ), AUTOMATORWP_WEBHOOKS_VER, true );

}
add_action( 'admin_init', 'automatorwp_webhooks_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_webhooks_admin_enqueue_scripts( $hook ) {

    global $post_type;

    // Stylesheets
    wp_enqueue_style( 'automatorwp-webhooks-admin-css' );

    // Localize admin script
    wp_localize_script( 'automatorwp-webhooks-admin-js', 'automatorwp_webhooks_admin', array(
        'nonce'             => automatorwp_get_admin_nonce(),
        'get_samples'       => __( 'We\'re checking for a new hook. We\'ll keep trying for 60 seconds.', 'automatorwp-pro' ),
        'no_samples_found'  => __( 'No samples found.', 'automatorwp-pro' ),
        'url_error'         => __( 'Please enter a valid webhook url.', 'automatorwp-pro' ),
    ) );

    // Scripts
    wp_enqueue_script( 'automatorwp-webhooks-admin-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_webhooks_admin_enqueue_scripts' );