<?php
/**
 * Add Referral To Affiliate
 *
 * @package     AutomatorWP\Integrations\AffiliateWP\Actions\Add_Referral_To_Affiliate
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_AffiliateWP_Add_Referral_To_Affiliate extends AutomatorWP_Integration_Action {

    public $integration = 'affiliatewp';
    public $action = 'affiliatewp_add_referral_to_affiliate';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add referral to user\'s affiliate', 'automatorwp-pro' ),
            'select_option'     => __( 'Add <strong>referral</strong> to user\'s affiliate', 'automatorwp-pro' ),
            /* translators: %1$s: Referral. */
            'edit_label'        => sprintf( __( 'Add %1$s to user\'s affiliate', 'automatorwp-pro' ), '{referral}' ),
            /* translators: %1$s: Referral. */
            'log_label'         => sprintf( __( 'Add %1$s to user\'s affiliate', 'automatorwp-pro' ), '{referral}' ),
            'options'           => array(
                'referral' => array(
                    'default' => __( 'referral', 'automatorwp-pro' ),
                    'fields' => array(
                        'description' => array(
                            'name' => __( 'Description:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'type' => array(
                            'name' => __( 'Type:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options_cb' => array( $this, 'referral_types_options_cb' ),
                            'default' => 'sale'
                        ),
                        'amount' => array(
                            'name' => __( 'Amount:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'attributes' => array(
                                'type' => 'number'
                            ),
                            'default' => '0.00'
                        ),
                        'status' => array(
                            'name' => __( 'Status:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'pending'   => __( 'Pending', 'automatorwp-pro' ),
                                'paid'      => __( 'Paid', 'automatorwp-pro' ),
                                'unpaid'    => __( 'Unpaid', 'automatorwp-pro' ),
                                'rejected'  => __( 'Rejected', 'automatorwp-pro' ),
                            ),
                            'default' => 'pending'
                        ),
                        'referral_date' => array(
                            'name' => __( 'Date:', 'automatorwp-pro' ),
                            'desc' => __( 'Enter the referral date in format YYYY-MM-DD. Leave empty for the date of the moment the referral gets created.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                )
            ),
        ) );

    }

    /**
     * Get referral types options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function referral_types_options_cb() {

        $options = array();

        foreach( affiliate_wp()->referrals->types_registry->get_types() as $type_id => $type ) {
            $options[$type_id] = $type['label'];
        }

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $description    = $action_options['description'];
        $type           = $action_options['type'];
        $amount         = $action_options['amount'];
        $status         = $action_options['status'];
        $date           = $action_options['referral_date'];

        // Get the user's affiliate ID
        $affiliate_id = automatorwp_affiliatewp_get_user_affiliate_id( $user_id );

        // Bail since user has not an affiliate
        if( ! $affiliate_id ) {
            return;
        }

        $args = array(
            'affiliate_id'  => $affiliate_id,
            'description'   => $description,
            'type'          => $type,
            'amount'        => (float) $amount,
            'status'        => $status,
            'date'          => $date,
        );

        affiliate_wp()->referrals->add( $args );

    }

}

new AutomatorWP_AffiliateWP_Add_Referral_To_Affiliate();