<?php
/**
 * Best Answer
 *
 * @package     AutomatorWP\Integrations\AnsPress\Triggers\Best_Answer
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_AnsPress_Best_Answer extends AutomatorWP_Integration_Trigger {

    public $integration = 'anspress';
    public $trigger = 'anspress_best_answer';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User answer is selected as best', 'automatorwp-pro' ),
            'select_option'     => __( 'User answer is <strong>selected as best</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User answer is selected as best %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User answer is selected as best', 'automatorwp-pro' ),
            'action'            => 'ap_select_answer',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Answer', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param WP_Post   $post
     * @param int       $question_id
     */
    public function listener( $post, $question_id  ) {

        $answer_id = $post->ID;
        $user_id = $post->post_author;

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'user_id' => $user_id,
            'post_id' => $answer_id,
        ) );

    }

}

new AutomatorWP_AnsPress_Best_Answer();