<?php
/**
 * Complete Lesson
 *
 * @package     AutomatorWP\Integrations\eLearnCommerce\Triggers\Complete_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_eLearnCommerce_Complete_Lesson extends AutomatorWP_Integration_Trigger {

    public $integration = 'elearncommerce';
    public $trigger = 'elearncommerce_complete_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User completes a lesson', 'automatorwp-pro' ),
            'select_option'     => __( 'User completes <strong>a lesson</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Lesson title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User completes %1$s %2$s time(s)', 'automatorwp-pro' ), '{lesson}', '{times}' ),
            /* translators: %1$s: Lesson title. */
            'log_label'         => sprintf( __( 'User completes %1$s', 'automatorwp-pro' ), '{lesson}' ),
            'action'            => 'wpep_user_activity_lesson_status',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'lesson' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'lesson',
                    'name'              => __( 'Lesson:', 'automatorwp-h5p' ),
                    'option_none_value' => 'any',
                    'option_none_label' => __( 'any lesson', 'automatorwp-h5p' ),
                    'action_cb'         => 'automatorwp_elearncommerce_get_lessons',
                    'options_cb'        => 'automatorwp_elearncommerce_options_cb_lesson',
                    'default'           => 'any'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $lesson_id
     * @param bool $is_completed
     * @param int $user_id
     */
    public function listener( $lesson_id, $is_completed, $user_id ) {

        // Bail if not completed or user is not set
        if( ! $is_completed || ! $user_id ) {
            return;
        }

        $course_id = WPEP\Entity\Course::instance()->get_course_id_by_lesson_id( $lesson_id );

        // Bail if lesson hasn't a course
        if( $course_id === null ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'lesson_id' => $lesson_id,
            'course_id' => $course_id,
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['lesson_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( absint( $trigger_options['lesson'] ) !== 0 && absint( $event['lesson_id'] ) !== absint( $trigger_options['lesson'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_eLearnCommerce_Complete_Lesson();