<?php
/**
 * Refresh Token
 *
 * @package     AutomatorWP\Integrations\Instagram\Refresh_Token
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register schedule events
 *
 * @since 1.3.2
 */
function automatorwp_instagram_refresh_token_schedule_events() {

    if ( function_exists( 'as_schedule_recurring_action' ) ) {

        // Action scheduler support
        if ( ! as_next_scheduled_action( 'automatorwp_instagram_refresh_token_event' ) ) {
            as_schedule_recurring_action( time(), MONTH_IN_SECONDS, 'automatorwp_instagram_refresh_token_event' );
        }

    } else {

        // WP Cron
        if ( ! wp_next_scheduled( 'automatorwp_instagram_refresh_token_event' ) ) {
            wp_schedule_event( time(), 'every_month', 'automatorwp_instagram_refresh_token_event' );
        }

    }

}
add_action( 'automatorwp_instagram_schedule_events', 'automatorwp_instagram_refresh_token_schedule_events' );

/**
 * Get the request parameters
 *
 * @since 1.0.0
 */
function automatorwp_instagram_refresh_token( ) {

    $client_id = automatorwp_instagram_get_option( 'client_id', '' );
    $client_secret = automatorwp_instagram_get_option( 'client_secret', '' );

    if( empty( $client_id ) || empty( $client_secret ) ) {
        return false;
    }

    $auth = get_option( 'automatorwp_instagram_auth', false );

    if( ! is_array( $auth ) ) {
        return false;
    }

    $params = array(
        'body'  => array(
            'grant_type'    => 'ig_refresh_token',
            'access_token'  => $auth['access_token'],
        )
    );

    $response = wp_remote_get( 'https://graph.instagram.com/refresh_access_token', $params );

    if( is_wp_error( $response ) ) {
        return false;
    }

    $body = json_decode( wp_remote_retrieve_body( $response ) );

    // Bail on receive an error
    if( isset( $body->error ) ) {
        return false;
    }

    $auth = array(
        'access_token'  => $body->access_token,
        'token_type'    => $body->token_type,
        'expires_in'    => $body->expires_in,
    );

    // Update the access and refresh tokens
    update_option( 'automatorwp_instagram_auth', $auth );

}
add_action( 'automatorwp_instagram_refresh_token_event', 'automatorwp_instagram_refresh_token' );
