(function ( $ ) {

    // Change the event
    $('body').on('change', '.automatorwp-action-modern-events-calendar-book-user .automatorwp-post-selector select', function(e) {
        var row = $(this).closest('.cmb-row');
        var ticket_row = row.next('.cmb-row');

        // Bail if next field is not a term selector
        if( ticket_row === undefined ) {
            return;
        }

        var event_id = $(this).val();
        var first_change = row.hasClass('is-option-change');

        if( event_id === 'any' || event_id === '' ) {
            // Hide the ticket selector
            if( first_change ) {
                ticket_row.hide();
            } else {
                ticket_row.slideUp('fast');
            }
        } else {
            var ticket_selector = ticket_row.find('select.select2-hidden-accessible');

            // Remove Select2 element
            ticket_selector.next('.select2').remove();

            // Update the event ID
            ticket_selector.data( 'event-id', event_id );

            if( ! first_change ) {
                // Update the the ticket value
                ticket_selector.val('');
            }

            // Reset the selector
            ticket_selector.removeAttr('data-select2-id');

            // Init it again
            automatorwp_ajax_selector( ticket_selector );

            // Show the ticket selector
            if( first_change ) {
                ticket_row.show();
            } else {
                ticket_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });

    // Append custom data to the ajax selector
    $('body').on('automatorwp_ajax_selector_data', '.automatorwp-action-modern-events-calendar-book-user .automatorwp-ajax-selector select', function(e, data, element) {
        data.event_id = element.data('event-id');
    });

    // On click on an option, check if form contains the event and ticket selector
    $('body').on('click', '.automatorwp-action-modern-events-calendar-book-user .automatorwp-automation-item-label > .automatorwp-option', function(e) {

        var item = $(this).closest('.automatorwp-automation-item');
        var option = $(this).data('option');
        var option_form = item.find('.automatorwp-option-form-container[data-option="' + option + '"]');
        var event_selector = option_form.find('.automatorwp-post-selector');

        if( event_selector !== undefined ) {
            event_selector.addClass('is-option-change');
            event_selector.find('select.select2-hidden-accessible').trigger('change');
        }

    });

})( jQuery );