<?php
/**
 * Plugin Name:           AutomatorWP - Newsletter
 * Plugin URI:            https://automatorwp.com/add-ons/newsletter/
 * Description:           Connect AutomatorWP with Newsletter.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-newsletter
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Newsletter
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Newsletter {

    /**
     * @var         AutomatorWP_Newsletter $instance The one true AutomatorWP_Newsletter
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Newsletter self::$instance The one true AutomatorWP_Newsletter
     */
    public static function instance() {
        if( !self::$instance ) {

            self::$instance = new AutomatorWP_Newsletter();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_NEWSLETTER_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_NEWSLETTER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_NEWSLETTER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_NEWSLETTER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_NEWSLETTER_DIR . 'includes/triggers/anonymous-subscribe-list.php';

            // Actions
            require_once AUTOMATORWP_NEWSLETTER_DIR . 'includes/actions/add-user-to-list.php';
            require_once AUTOMATORWP_NEWSLETTER_DIR . 'includes/actions/add-contact-to-list.php';
            require_once AUTOMATORWP_NEWSLETTER_DIR . 'includes/actions/remove-user-from-list.php';
            require_once AUTOMATORWP_NEWSLETTER_DIR . 'includes/actions/remove-contact-from-list.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'newsletter', array(
            'label' => 'Newsletter',
            'icon'  => AUTOMATORWP_NEWSLETTER_URL . 'assets/newsletter.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'NEWSLETTER_VERSION' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Newsletter instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Newsletter The one true AutomatorWP_Newsletter
 */
function AutomatorWP_Newsletter() {
    return AutomatorWP_Newsletter::instance();
}
add_action( 'automatorwp_pre_init', 'AutomatorWP_Newsletter' );
