<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Restrict_Content\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_restrict_content_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-restrict-content-admin-css', AUTOMATORWP_RESTRICT_CONTENT_URL . 'assets/css/automatorwp-restrict-content-admin' . $suffix . '.css', array( ), AUTOMATORWP_RESTRICT_CONTENT_VER, 'all' );
    wp_register_style( 'automatorwp-restrict-content-access-levels-admin-css', AUTOMATORWP_RESTRICT_CONTENT_URL . 'assets/css/automatorwp-restrict-content-access-levels-admin' . $suffix . '.css', array( ), AUTOMATORWP_RESTRICT_CONTENT_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-restrict-content-admin-js', AUTOMATORWP_RESTRICT_CONTENT_URL . 'assets/js/automatorwp-restrict-content-admin' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_RESTRICT_CONTENT_VER, true );
    wp_register_script( 'automatorwp-restrict-content-access-levels-admin-js', AUTOMATORWP_RESTRICT_CONTENT_URL . 'assets/js/automatorwp-restrict-content-access-levels-admin' . $suffix . '.js', array( 'jquery', 'jquery-ui-dialog' ), AUTOMATORWP_RESTRICT_CONTENT_VER, true );

}
add_action( 'admin_init', 'automatorwp_restrict_content_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_restrict_content_admin_enqueue_scripts( $hook ) {

    automatorwp_enqueue_admin_functions_script();

    // Stylesheets
    wp_enqueue_style( 'automatorwp-restrict-content-admin-css' );

    // Localize admin script
    wp_localize_script( 'automatorwp-restrict-content-admin-js', 'automatorwp_restrict_content_admin', array(
        'ajaxurl'           => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
        'nonce'             => automatorwp_get_admin_nonce(),
    ) );

    // Scripts
    wp_enqueue_script( 'automatorwp-restrict-content-admin-js' );


    // Restrict Content level, add and edit screens
    if( $hook === 'automatorwp_page_automatorwp_restrict_content_access_levels' || $hook === 'admin_page_edit_automatorwp_restrict_content_access_levels' ) {

        // Stylesheets
        wp_enqueue_style( 'automatorwp-restrict-content-access-levels-admin-css' );

        // Localize admin script
        wp_localize_script( 'automatorwp-restrict-content-access-levels-admin-js', 'automatorwp_restrict_content_access_levels_admin', array(
            'ajaxurl'           => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
            'nonce'             => automatorwp_get_admin_nonce(),
            'no_user_selected'  => __( 'Select a user first.', 'automatorwp-pro' ),
            'shortcode_pattern'  => '[awp_rc access_level="SLUG"]' . __( 'Content to show', 'automatorwp-pro' ) .  '[/awp_rc]',
        ) );

        // Scripts
        wp_enqueue_script( 'automatorwp-restrict-content-access-levels-admin-js' );

    }
}
add_action( 'admin_enqueue_scripts', 'automatorwp_restrict_content_admin_enqueue_scripts' );