<?php
/**
 * Update Description
 *
 * @package     AutomatorWP\Integrations\Ultimate_Member\Triggers\Update_Description
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Ultimate_Member_Update_Description extends AutomatorWP_Integration_Trigger {

    public $integration = 'ultimate_member';
    public $trigger = 'ultimate_member_update_description';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User updates profile description', 'automatorwp-pro' ),
            'select_option'     => __( 'User updates <strong>profile description</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User updates profile description %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User updates profile description', 'automatorwp-pro' ),
            'action'            => 'um_after_user_updated',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int       $user_id    The user ID
     * @param array     $args       Contains all form fields
     * @param array     $userinfo   Contains all field to be updated
     */
    public function listener( $user_id, $args, $userinfo ) {

        $user_id = absint( $user_id );

        // Bail if user didn't updated the description
        if( ! isset( $userinfo['description'] ) ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_Ultimate_Member_Update_Description();