<?php

namespace BookneticApp\Backend\Appointments\Helpers;

class ExtrasService
{
    public static function calcExtrasPrice($serviceExtras)
    {
        $extrasPrice = 0;

        foreach ($serviceExtras as $extraInf) {
            $extrasPrice += $extraInf['quantity'] * $extraInf['price'];
        }

        return $extrasPrice;
    }

    public static function calcExtrasDuration($serviceExtras)
    {
        $extrasDuration = 0;

        if (empty($serviceExtras)) {
            return 0;
        }

        $uniqueByExtraId = [];
        foreach ($serviceExtras as $extra) {
            $id = $extra['id'];
            $duration = (int)$extra['duration'] * (int)$extra['quantity'];

            if (!isset($uniqueByExtraId[ $id ])) {
                $uniqueByExtraId[ $id ] = 0;
            }

            $uniqueByExtraId[ $id ] = max($uniqueByExtraId[ $id ], $duration);
        }

        foreach ($uniqueByExtraId as $duration) {
            $extrasDuration += $duration;
        }

        return $extrasDuration;
    }
}
