<?php
/*
 *  Copyright (c) 2025 Borlabs GmbH. All rights reserved.
 *  This file may not be redistributed in whole or significant part.
 *  Content of this file is protected by international copyright laws.
 *
 *  ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 *  @copyright Borlabs GmbH, https://borlabs.io
 */

declare(strict_types=1);

namespace Borlabs\Cookie\ApiClient\Transformer;

use Borlabs\Cookie\Dto\Package\SuggestedPackageDto;
use Borlabs\Cookie\DtoList\Package\SuggestedPackageDtoList;

final class SuggstedPackageListTransformer
{
    public function toDto(object $suggestedPackages): SuggestedPackageDtoList
    {
        $suggestedPackageList = new SuggestedPackageDtoList([]);

        foreach ($suggestedPackages as $suggestedPackage) {
            $suggestedPackageList->add(
                new SuggestedPackageDto($suggestedPackage->key),
            );
        }

        return $suggestedPackageList;
    }
}
