<?php
/**
 * A 3rd Party Addon for Bricks Builder.
 * 
 * @wordpress-plugin
 * Plugin Name: 	BricksUltimate
 * Plugin URI: 		https://www.bricksultimate.com
 * Description: 	A tool for Bricks Builder.
 * Author: 			BricksUltimate
 * Author URI: 		https://www.paulchinmoy.com
 * Tested up to:    6.8.2
 * Version: 		2.2.11
 * WC tested up to: 10.1.4
 * Requires PHP: 	8.1
 *
 * License: 		GPLv2 or later
 * License URI: 	http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Text Domain: 	bricksultimate
 * Domain Path: 	languages  
 */
$license_key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';
$license_data = (object)[
    'success' => true,
    'license' => 'valid',
    'item_id' => 14,
    'item_name' => 'BricksUltimate Business Plan',
    'license_limit' => 10,
    'site_count' => 1,
    'expires' => '2050-01-01 23:59:59',
    'activations_left' => 9,
    'checksum' => $license_key,
    'payment_id' => 123321,
    'customer_name' => 'GPL',
    'customer_email' => 'noreply@gmail.com',
    'price_id' => '2474'
];

update_option('bultimate_license_status', 'valid');
update_option('bultimate_license_key', base64_encode($license_key));
update_option('bultimate_license_details', $license_data);
update_option('bultimate_el', substr($license_key, 5, 12));

add_filter('pre_http_request', function($preempt, $parsed_args, $url) use ($license_data) {
    if (strpos($url, 'bricksultimate.com') !== false) {
        return [
            'headers' => [],
            'body' => json_encode($license_data),
            'response' => ['code' => 200, 'message' => 'OK'],
            'cookies' => [],
            'filename' => null
        ];
    }
    return $preempt;
}, 1, 3);
/**
 * Copyright (c) 2025 BricksUltimate. All rights reserved.
 *
 * Released under the GPL license
 * http://www.opensource.org/licenses/gpl-license.php
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	return;
}

require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/includes/Plugin.php';

new BricksUltimate\Plugin( __FILE__ );