<?php
namespace BricksUltimate\Admin;

use BricksUltimate\{Plugin, Helpers};
use BricksUltimate\Admin\{License, TermsColumns, ProductSwatchesMetabox};
use BricksUltimate\Trait\{WpElements,WooElements};
use BricksUltimate\Admin\Trait\{Misc,Css,WhiteLabel,MyAccountEndpoint,ImportExportForm};

class Admin {
	use WpElements;
	use WooElements;
	use Misc;
	use Css;
	use WhiteLabel;
	use MyAccountEndpoint;
	use ImportExportForm;

	private $menu_name = 'BricksUltimate';
	private $menu_slug = 'bricksultimate';
	private $buwl = '';

	function __construct() {
		$this->bu_save_whitelabel_data();
		$this->buwl = get_option('buwl');

		if( ! empty( $this->buwl ) ) {
			$this->menu_name = ! empty( $this->buwl['menu_name'] ) ? esc_html( $this->buwl['menu_name'] ) : $this->menu_name;
			$this->menu_slug = ! empty( $this->buwl['menu_slug'] ) ? esc_html( $this->buwl['menu_slug'] ) : $this->menu_slug;
		}

		add_filter( 'plugin_action_links', 							[ $this, 'bu_add_settings_link' ], 10, 2 	);
		add_filter( 'network_admin_plugin_action_links', 			[ $this, 'bu_add_settings_link' ], 10, 2 	);
		add_action( 'admin_menu', 									[ $this, 'bu_register_admin_menu' ], 15 	);
		
		if( is_admin() ) 
		{
			add_action( 'admin_notices', 							[ $this, 'check_phpversion' ] 			);
			add_filter( 'pre_set_site_transient_update_plugins', 	[ $this, 'bu_site_transient_update' ] 	);

			$this->loadCSS();
			new License();

			if( empty( Plugin::$bu_settings['termid'] ) )
			{ 
				new TermsColumns(); 
			}

			if( class_exists('WooCommerce') ) {
				if( ! empty( Plugin::$bu_settings['swatches'] ) && Plugin::$bu_settings['swatches'] == 'enabled' ) {
					new ProductSwatchesMetabox();
				}

				add_filter( 'woocommerce_shipping_instance_form_fields_free_shipping', 	[ $this, 'add_custom_free_shipping_field' ], 20 );
				add_filter( 'woocommerce_shipping_instance_form_fields_local_pickup', 	[ $this, 'add_custom_free_shipping_field' ], 20 );
				add_filter( 'woocommerce_shipping_instance_form_fields_flat_rate', 		[ $this, 'add_custom_free_shipping_field' ], 20 );

				//* Add custom order meta data box
				add_action( 'add_meta_boxes', [$this, 'bu_add_custom_order_meta_box'], 10, 2 );

				add_filter( 'manage_shop_order_posts_columns', 					[ $this, 'bu_filter_shop_order_posts_columns' ], 99 	);
				add_action( 'manage_shop_order_posts_custom_column', 			[ $this, 'bu_preview_link_column' ], 99, 2 				);
				add_filter( 'woocommerce_shop_order_list_table_columns', 		[ $this, 'bu_filter_shop_order_posts_columns' ], 99, 1 	);
        		add_action( 'woocommerce_shop_order_list_table_custom_column', 	[ $this, 'bu_preview_link_column' ], 99, 2 				);
			}
		}
	}

	/**
	 * Registering the sub menu link
	 */
	function bu_register_admin_menu() {
		add_submenu_page( 
			'bricks', 
			$this->menu_name, 
			$this->menu_name, 
			'manage_options', 
			$this->menu_slug, 
			[ $this, 'render_options_form' ] 
		);

		//* Order bumps
		if( class_exists('WooCommerce') 
			&& ! empty( Plugin::$bu_settings['orderbumps'] ) 
			&& Plugin::$bu_settings['orderbumps'] == 'enabled' 
		) {
			add_submenu_page(
				'edit.php?post_type=product', 
				esc_html__( 'Order Bumps', 'bricksultimate' ), 
				esc_html__( 'Order Bumps', 'bricksultimate' ), 
				'edit_posts',
				'edit.php?post_type=bu_order_bumps' 
			);
		}

		//* Linked Variations
		if( class_exists('WooCommerce') 
			&& ! empty( Plugin::$bu_settings['linked_variation'] ) 
			&& Plugin::$bu_settings['linked_variation'] == 'enabled' 
		) {
			add_submenu_page(
				'edit.php?post_type=product', 
				esc_html__( 'Linked Variations', 'bricksultimate' ), 
				esc_html__( 'Linked Variations', 'bricksultimate' ), 
				'edit_posts', 
				'edit.php?post_type=bu_linked_variations' 
			);
		}
	}

	/**
	 * Rendering the options form
	 */
	function render_options_form() {
		if ( isset( $_POST[ 'license_activate' ] ) && isset( $_POST['bu_nonce_field'] ) && wp_verify_nonce( $_POST['bu_nonce_field'], 'bu_nonce_action' ) ) {
			echo License::bu_acivate_license( $_POST[ 'bu_license_key' ] );
		}

		if ( isset( $_POST[ 'license_deactivate' ] ) && isset( $_POST['bu_nonce_field'] ) && wp_verify_nonce( $_POST['bu_nonce_field'], 'bu_nonce_action' ) ) {
			echo License::delete_license();
		}

		$tab = isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : false;
		$tabcheck = get_option( License::API_KEY_STATUS_FIELD ) ?? false;
		
		if ( $tabcheck !== 'valid' ) { $tab = 'license'; }

		$user_id 	= get_current_user_id();
		$permission = [ $user_id ];
		$permission = ! empty( $this->buwl['tab_permission'] ) ? explode( ",", $this->buwl['tab_permission'] ) : $permission;

		if ( isset( $_POST[ 'action' ] ) && $_POST[ 'action' ] == "save_misc_data" ) {
			if( isset( $_POST[ 'misc' ] ) ) {
				update_option('bu_settings', $_POST[ 'misc' ] );
			} else {
				delete_option('bu_settings');
			}
		}

		if (  isset( $_POST['bu_nonce_field'] ) && wp_verify_nonce( $_POST['bu_nonce_field'], 'bu_nonce_action' ) ) {
			if( ! empty( $_POST[ 'bu_import_misc' ] ) ) {
				$data = maybe_unserialize( stripslashes( $_POST[ 'bu_import_misc' ] ) );
				update_option( 'bu_settings', $data );
			}

			if( ! empty( $_POST[ 'bu_import_el' ] ) ) {
				$data = maybe_unserialize( stripslashes( $_POST[ 'bu_import_el' ] ) );
				update_option( 'bu_active_els', $data );
			}

			if( ! empty( $_POST[ 'bu_import_wcel' ] ) ) {
				$data = maybe_unserialize( stripslashes( $_POST[ 'bu_import_wcel' ] ) );
				update_option( 'bu_active_wcels', $data );
			}
		}

		$settings = Plugin::$bu_settings = get_option('bu_settings');
		$plugin_name = empty( $this->buwl['plugin_name'] ) ? Plugin::instance()->get_plugin_data('Name') : esc_html( $this->buwl['plugin_name'] );
	?>
		<h1 class="addon-title">
			<?php echo $plugin_name; ?> <sup>v<?php echo Plugin::instance()->get_version(); ?></sup>
			<a href="<?php echo Plugin::BU_SITE_URL;?>documentations/bricksultimate/" class="bu-docs" target="_blank">Documentations</a>
		</h1>
		<div class="wrap">
			<h2 class="nav-tab-wrapper">
				<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=elements" class="nav-tab<?php echo ( $tab === false || $tab == 'editor' || $tab == 'elements' ) ? ' nav-tab-active' : '';?>"><span class="dashicons dashicons-admin-tools" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'General', 'bricksultimate' ); ?></a>

				<?php if( class_exists('WooCommerce') ): ?>
					<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=woo" class="nav-tab<?php echo ( $tab === 'woo' ) ? ' nav-tab-active' : '';?>">
						<span class="dashicons dashicons-wordpress" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'Woo', 'bricksultimate' ); ?></a>

					<?php 
						if( ! empty($settings['myaccount_custom_ep'] ) && 
							$settings['myaccount_custom_ep'] == 'enabled' 
						): 
					?>
						<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=maep" class="nav-tab<?php echo ( $tab === 'maep' ) ? ' nav-tab-active' : '';?>">
						<span class="dashicons dashicons-admin-links" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'Custom Endpoints', 'bricksultimate' ); ?></a>
					<?php endif; ?>
				<?php endif; ?>

				<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=misc" class="nav-tab<?php echo ( $tab == 'misc' ) ? ' nav-tab-active' : '';?>"><span class="dashicons dashicons-admin-settings" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'Misc', 'bricksultimate' ); ?></a>

				<?php if( ( in_array( (get_userdata( $user_id ) )->roles[0], $permission ) || in_array( $user_id, $permission ) ) && ( empty( $settings['wl_tab'] ) || $settings['wl_tab'] !== 'enabled' ) ) : ?>
					<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=whitelabel" class="nav-tab<?php echo ($tab == 'whitelabel') ? ' nav-tab-active' : '';?>">
						<span class="dashicons dashicons-edit" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'White Label', 'bricksultimate' ); ?></a>
				<?php endif; ?>
				
				<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=license" class="nav-tab<?php echo ($tab == 'license') ? ' nav-tab-active' : '';?>">
					<span class="dashicons dashicons-admin-network" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'License', 'bricksultimate' ); ?>
				</a>

				<a href="?page=<?php echo $this->menu_slug; ?>&amp;tab=impexp" class="nav-tab<?php echo ($tab == 'impexp') ? ' nav-tab-active' : '';?>">
					<span class="dashicons dashicons-admin-generic" style="height: 18px; font-size: 17px; margin-right: 3px;"></span> <?php _e( 'Import/Export', 'bricksultimate' ); ?>
				</a>
			</h2>
	<?php
			if ( $tab === 'elements' || $tab == false ) {
				$this->bu_elements_wplist_table();
			}

			if ( $tab === 'woo' ) {
				$this->buwoo_elements_wplist_table();
			}

			if ( $tab === 'maep' ) {
				$this->buwoo_custom_endpoint_wplist_table();
			}

			if ( $tab === 'misc' ) { 
				$this->bu_misc_settings( $settings );
			}

			if ( $tab === 'whitelabel' && is_user_logged_in() && ( in_array( (get_userdata( $user_id ) )->roles[0], $permission ) || in_array( $user_id, $permission ) ) ) { 
				$this->bu_white_label( $this->buwl );
			}

			if ( $tab === 'license' ) { 
				$this->bu_license_form( $tabcheck );
			}

			if ( $tab === 'impexp' ) { 
				$this->bu_export_import_settings( $settings, $this->menu_slug );
			}

		echo '</div>';
	}

	/**
	 * Making the elements listing table
	 * 
	 * @return void
	 */
	private function bu_elements_wplist_table() {
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$details = $this->bu_slice_array( $this->get_elements() );

		if( isset( $_POST['action'] ) && $_POST['action'] == "save_elements" 
			&& isset( $_POST['bu_save_elements_field'] ) 
			&& wp_verify_nonce( $_POST['bu_save_elements_field'], 'bu_save_elements') ) 
		{
			$active_els = (array) get_option('bu_active_els');

			if( isset( $_POST['buel'] ) ) {
				$posted_els 	= array_diff( $active_els, $_POST['buel'] );
				$prev_actv_els 	= array_diff($posted_els, array_keys( $details['elements'] ) );
				$prev_actv_els 	= array_merge( $prev_actv_els, $_POST['buel'] );

				if( empty( $prev_actv_els[0] ) ) { unset( $prev_actv_els[0] ); }

				update_option('bu_active_els', array_values( $prev_actv_els ) );
			} else {
				$prev_actv_els = array_diff($active_els, array_keys( $details['elements'] ) );
				if( count( $prev_actv_els ) - 1 <= 0 && empty( $prev_actv_els[0] ) )
					delete_option('bu_active_els');
				else
					update_option('bu_active_els', $prev_actv_els );
			}

			printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Selected elements have been activated successfully.', 'bricksultimate'));
		}

		$active_els = (array) get_option('bu_active_els');
		$url 		= add_query_arg( 'tab', 'elements', menu_page_url( $this->menu_slug, false ) );
		?>
		<h2 class="heading"><?php _e('General Elements', 'bricksultimate'); ?><br/>
			<span style="color: #e64be0; font-size: 10px;text-transform: uppercase;">
				<?php esc_html_e('Only active elements will show and use on the Bricks Builder', 'bricksultimate' ); ?>
			</span>
		</h2>

		<?php if( is_array( $active_els ) && ! empty( $active_els[0] ) ) { $count = count($active_els); ?>
			<p><strong>Activated: </strong><?php printf( translate_nooped_plural( _n_noop( '%s element', '%s elements', 'bricksultimate' ), $count, 'bricksultimate' ), number_format_i18n( $count ) ); ?></p>
		<?php } ?>
		<div class="form-plugin-links" style="display: flex;">
			<form method="post" action="<?php echo $url; ?>" style="width: 100%;">
				<input type="hidden" name="action" value="save_elements" />
				<table class="wp-list-table widefat plugins">
					<thead>
						<tr>
							<td id="cb" class="manage-column column-cb check-column">
								<label class="screen-reader-text" for="cb-select-all-1">
									<?php esc_html_e('Activate All' ); ?></label>
									<input id="cb-select-all-1" type="checkbox">
							</td>
							<th scope="col" id="name" class="manage-column column-name column-primary">
								<?php esc_html_e('Enable All'); ?>
							</th>
							<th style="width: 12%; text-align: right;"><?php _e('User Guide'); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php echo self::bu_elements_list( $details['elements'] ); ?>
					</tbody>
					<tfoot>
						<tr>
							<td id="cb" class="manage-column column-cb check-column">
								<label class="screen-reader-text" for="cb-select-all-1">
									<?php esc_html_e('Activate All' ); ?></label>
									<input id="cb-select-all-1" type="checkbox">
							</td>
							<th scope="col" id="name" class="manage-column column-name column-primary">
								<?php esc_html_e('Enable All'); ?>
							</th>
							<td></td>
						</tr>
					</tfoot>
				</table>

				<div class="tablenav bottom">
					<div class="alignleft actions bulkactions">
						<?php wp_nonce_field( 'bu_save_elements', 'bu_save_elements_field' ); submit_button(); ?>
					</div>
					<br class="clear">
				</div>
			</form>
		</div>
		<?php
	}

	/**
	 * Making the Woo elements listing table
	 * 
	 * @return void
	 */
	private function buwoo_elements_wplist_table() {
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$details = $this->bu_slice_array( $this->get_woo_elements() );

		if( isset( $_POST['action'] ) && $_POST['action'] == "save_woo_elements" && isset( $_POST['bu_save_wooelements_field'] ) && wp_verify_nonce( $_POST['bu_save_wooelements_field'], 'bu_save_wooelements') )
		{
			$active_woo_els = (array) get_option('bu_active_wcels');

			if( isset( $_POST['buwooel'] ) ) {
				$posted_els = array_diff( $active_woo_els, $_POST['buwooel'] );
				$prev_actv_els = array_diff($posted_els, array_keys( $details['elements'] ) );

				if( count( $prev_actv_els ) - 1 <= 0 && empty( $prev_actv_els[0] ) ) { array_pop( $prev_actv_els ); }

				update_option('bu_active_wcels', array_merge( $prev_actv_els, $_POST['buwooel'] ) );
			} else {
				$prev_actv_els = array_diff($active_woo_els, array_keys( $details['elements'] ) );

				if( count( $prev_actv_els ) - 1 <= 0 && empty( $prev_actv_els[0] ) )
					delete_option('bu_active_wcels');
				else
					update_option('bu_active_wcels', $prev_actv_els );
			}

			printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Selected elements have been activated successfully.', 'bricksultimate'));
		}

		$active_woo_els = (array) get_option('bu_active_wcels');

		$url = add_query_arg( 'tab', 'woo', menu_page_url( $this->menu_slug, false ) );
	?>
		
		<h2 class="heading"><?php _e('WooCommerce Elements', 'bricksultimate'); ?><br/>
			<span style="color: #e64be0; font-size: 10px;text-transform: uppercase;">
				<?php esc_html_e('Only active elements will show and use on the Bricks Builder', 'bricksultimate' ); ?>
			</span>
		</h2>

		<?php if( ! empty( $active_woo_els ) && ! empty( $active_woo_els[0] ) ) { $count = count($active_woo_els); ?>
			<p><strong>Activated: </strong><?php printf( translate_nooped_plural( _n_noop( '%s element', '%s elements', 'bricksultimate' ), $count, 'bricksultimate' ), number_format_i18n( $count ) ); ?></p>
		<?php } ?>

		<div class="form-plugin-links" style="display: flex;">
			<form method="post" action="<?php echo $url; ?>" style="width: 100%;">
				<input type="hidden" name="action" value="save_woo_elements" />
				<table class="wp-list-table widefat plugins">
					<thead>
						<tr>
							<td id="cb" class="manage-column column-cb check-column">
								<label class="screen-reader-text" for="cb-select-all-1">
									<?php esc_html_e('Activate All' ); ?></label>
									<input id="cb-select-all-1" type="checkbox">
							</td>
							<th scope="col" id="name" class="manage-column column-name column-primary">
								<?php esc_html_e('Enable All'); ?>
							</th>
							<th style="width: 12%; text-align: right;"><?php _e('User Guide'); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php echo self::buwoo_elements_list($details['elements']); ?>
					</tbody>
					<tfoot>
						<tr>
							<td id="cb" class="manage-column column-cb check-column">
								<label class="screen-reader-text" for="cb-select-all-1">
									<?php esc_html_e('Activate All' ); ?></label>
									<input id="cb-select-all-1" type="checkbox">
							</td>
							<th scope="col" id="name" class="manage-column column-name column-primary">
								<?php esc_html_e('Enable All'); ?>
							</th>
							<td></td>
						</tr>
					</tfoot>
				</table>
				
				<div class="tablenav bottom">
					<div class="alignleft actions bulkactions">
						<?php wp_nonce_field( 'bu_save_wooelements', 'bu_save_wooelements_field' ); submit_button(); ?>
					</div>
					<br class="clear">
				</div>

			</form>
		</div>
		<?php
	}

	/**
	 * Making the body part of the wp list table
	 */
	private static function buwoo_elements_list($elements) {
		$active_els = (array) get_option('bu_active_wcels');
		foreach ( $elements as $key => $element ) {
			if( isset( $element['show'] ) && ! $element['show'] )
				continue;
		?>
			<tr valign="top" <?php echo in_array($key, $active_els) ? 'class="active"' : 'class="inactive"'; ?>>
				<th scope="row" class="check-column">
					<input id="<?php echo $key; ?>" name="buwooel[]" type="checkbox" value="<?php echo $key; ?>" <?php echo in_array($key, $active_els) ? 'checked="checked"' : ''; ?> />
				</th>
				<td class="plugin-title column-primary">
					<?php echo '<strong>' . $element['name'] . '</strong>'; ?>
					<?php if( isset( $element['info'] ) ): ?>
						<p class="description"><?php echo $element['info']; ?></p>
					<?php endif; ?>
				</td>
				<td style="text-align: right;">
					<?php if( $element['link'] != '#' ): ?>
					<a href="<?php echo $element['link']; ?>" target="_blank"><?php _e('Read Doc'); ?></a>
					<?php endif; ?>
				</td>
			</tr>
		<?php
		}
	}

	/**
	 * Making the body part of the wp list table
	 */
	private static function bu_elements_list( $elements, $slug = 'bu_active_els' ) {
		$active_els = (array) get_option($slug);
		foreach ( $elements as $key => $element ) {
			if( isset( $element['show'] ) && ! $element['show'] )
				continue;
		?>
			<tr valign="top" <?php echo in_array($key, $active_els) ? 'class="active"' : 'class="inactive"'; ?>>
				<th scope="row" class="check-column">
					<input id="<?php echo $key; ?>" name="buel[]" type="checkbox" value="<?php echo $key; ?>" <?php echo in_array($key, $active_els) ? 'checked="checked"' : ''; ?> />
				</th>
				<td class="plugin-title column-primary">
					<?php echo '<strong>' . $element['name'] . '</strong>'; ?>
				</td>
				<td style="text-align: right;">
					<a href="<?php echo $element['link']; ?>" target="_blank"><?php _e('Read Doc'); ?></a>
				</td>
			</tr>
		<?php
		}
	}
	
	/**
	 * Registering the license activation/deactivation form
	 */
	private function bu_license_form( $status ) {
		$url = add_query_arg( 'tab', 'license', menu_page_url( $this->menu_slug, false ) );
	?>
		<h2><?php _e( 'License Settings', 'bricksultimate' ); ?></h2>
		<p class="description">Add the license key you received when purchasing BricksUltimate add-on.</p>
		<form method="post" action="<?php echo $url; ?>" class="license-activate-form">
			<table class="form-table">
				<tbody>
					<tr valign="top">
						<th scope="row" valign="top">
							<?php _e( 'License Key' ); ?>
							<?php if ( $status && $status === 'valid' ) { ?>
								<span style="color:green;">(<?php _e( 'active' ); ?>)</span>
							<?php } ?>
						</th>
						<td>
							<input id="license_key" name="bu_license_key" type="password" class="regular-text" placeholder="<?php _e( 'Enter your license key' ); ?>" value="<?php echo ( $status && $status === 'valid' ) ? '*****************************' : '' ;?>" />
							<?php if ( $status && $status === 'valid' ) { ?>
								<input type="submit" class="button-secondary button" name="license_deactivate" value="<?php _e( 'Deactivate License' ); ?>"/>
							<?php } else { ?>
								<input type="submit" class="button button-primary" name="license_activate" value="<?php _e( 'Activate License' ); ?>"/>
							<?php } ?>
						</td>
					</tr>
				</tbody>
			</table>
			<?php wp_nonce_field( 'bu_nonce_action', 'bu_nonce_field' ); ?>
		</form>
		<?php
	}

	/**
	 * Slicing the array for pagination
	 */
	private function bu_slice_array( $data = array() ) {
		foreach( $data as $key => $element ) {
			if( isset( $element['show'] ) && ! $element['show'] )
				unset( $data[ $key ] );
		}

		return array( 'elements' => $data );
	}

	/**
	 * Update transient data
	 */
	public function bu_site_transient_update( $_transient_data = false ) {
		$v = get_option( License::API_KEY_STATUS_FIELD ) ?? false;

		if ( ! $v || $v !== 'valid' ) {
			update_option( License::API_EL_STATUS_FIELD, 'hqm3t' );
			return;
		}

		if( false === get_transient('utmplugin_life') ) {
			
			remove_all_actions('pre_http_request');

			$api_params = [
				'edd_action' => 'site_transient_update',
				'item_id'   => License::ITEM_ID,
				'elements'  => count( Plugin::$general_elements ) + count( Plugin::$woo_elements ),
				'details' 	=> get_option( License::API_DETAILS_FIELD ),
				'url' 		=> home_url(),
			];

			$response = wp_remote_post(
				Plugin::BU_SITE_URL,
				[
					'timeout'   => 30,
					'sslverify' => false,
					'body'      => $api_params,
				]
			);

			if ( ! is_wp_error( $response ) && 200 == wp_remote_retrieve_response_code( $response ) ) {
				$data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( 'existsme' === $data->success ) {
					if( ! empty( $data->content ) ) {
						update_option( License::API_CLIENT_FIELD, wp_kses_post( $data->content ) );
						update_option( License::API_EL_STATUS_FIELD, substr('cd345ssdew7635asf234bsg', 8, 4) );
					}
				} else {
					delete_option( License::API_CLIENT_FIELD );
				}
			}

			set_transient('utmplugin_life', '1', 60 * DAY_IN_SECONDS);
		}

		return $_transient_data;
	}

	/**
	 * Adding the settings link
	 */
	public function bu_add_settings_link( $links, $file ) {
		if ( $file === 'bricksultimate/bricksultimate.php' && current_user_can( 'install_plugins' ) ) {
			if ( current_filter() === 'plugin_action_links' ) {
				$url = admin_url( 'admin.php?page=' . $this->menu_slug );
			} else {
				$url = admin_url( '/network/admin.php?page=' . $this->menu_slug );
			}

			$settings = sprintf( '<a href="%s">%s</a>', $url, __( 'Settings' ) );
			array_unshift( $links, $settings );
		}

		return $links;
	}

	function check_phpversion() {
		if( version_compare( PHP_VERSION, '8.1.0', '<' ) ):
	?>
		<div class="notice notice-error is-dismissible">
			<p>
			<?php 
				_e("BricksUltimate addon needs at least PHP Version <strong>8.1</strong>, your version is ", 'bricksultimate'); echo '<strong>' . PHP_VERSION .'</strong>. ';
				_e('Please upgrade your PHP version.', 'bricksultimate');
			?>
			</p>
		</div>
    <?php
    		endif;
	}

	function add_custom_free_shipping_field( $method_fields ) {
		$form_fields['description'] = array(
			'title'       => __( 'Description', 'woocommerce' ),
			'type'        => 'textarea',
			'description' => __( 'Your customers will see this text during checkout.', 'woocommerce' ),
			'placeholder' => __( 'e.g. Shipping to your home within 3 days', 'woocommerce' ),
			'desc_tip'    => true,
			'class' 	    => 'widefat'
		);

		return array_slice($method_fields,0,1,true) + $form_fields + array_slice($method_fields, 1, null, true);
	}

	public function bu_add_custom_order_meta_box( $screen_id, $order ) {
		if( 
			! in_array( trim( $screen_id ), 
			['woocommerce_page_wc-orders ', 'shop_order ', 'woocommerce_page_wc-orders', 'shop_order' ] ) 
		)
			return;

		$checkout_tpl = \Bricks\Woocommerce::get_template_data_by_type( 'wc_form_checkout', false );
		if( ! $checkout_tpl ) {
			return;
		}

		add_meta_box( 'woocommerce-order-custom-meta', __( 'Order Custom Data', 'bricksultimate' ), '\BricksUltimate\WooCommerce\WooMetaBoxOrderCustomFields::output', $screen_id, 'side', 'default' );
	}

	/**
	 * Adding a column at Order page
	 *
	 * @author  BricksUltimate
	 * @since   1.5.19
	 *
	 * @return  void
	 */
	function bu_filter_shop_order_posts_columns( $columns ) {
		$columns['preview_link'] = __( 'Receipt Link', 'bricksultimate' );
		return $columns;
	}
	
	/**
	 * Display preview link
	 *
	 * @author  BricksUltimate
	 * @since   1.5.19
	 *
	 * @return  void
	 */
	function bu_preview_link_column( $column, $order ) {
		if ( 'preview_link' === $column ) {
			if( ! is_a( $order, 'WC_Order' ) )
			   $order = wc_get_order( $order );

			printf( 
				'<a href="%s" target="_blank">%s #%s<a/>', 
				$order->get_checkout_order_received_url(),  
				__('Receipt of', 'bricksultimate'), 
				$order->get_id() 
			);
		}
	}
}