<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Comments {
	public function __construct() {
		add_filter( "bricks/elements/post-comments/control_groups", [ $this, 'add_post_comments_control_groups' ] );
		add_filter( "bricks/elements/post-comments/controls", [ $this, 'add_post_comments_controls' ] );
	}

	/**
	 * Adds extra control group for post comments element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_post_comments_control_groups( $control_groups ) {
		$control_groups['replyButton'] = [
			'title' => esc_html__( 'Reply button', 'bricksultimate' ),
			'tab'   => 'content',
		];

		return $control_groups;
	}

	/**
	 * Adds extra controls for post comments element
	 * 
	 * @since 0.4
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	public function add_post_comments_controls( $controls ) {
		$controls['inputBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Field box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => '.form-group input',
				],
				[
					'property' => 'box-shadow',
					'selector' => '.form-group textarea',
				],
			],
		];

		$controls['formTitleTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__('Form Title Typography', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.comment-reply-title'
				]
			]
		];

		$controls['cancelReply'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__('Cancel Reply Link', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '#cancel-comment-reply-link'
				]
			]
		];

		$controls['focusSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__('Field Focus Effect', 'bricksultimate'),
		];

		$controls['focusInputBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Field background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => '.form-group input:focus',
				],
				[
					'property' => 'background-color',
					'selector' => '.form-group textarea:focus',
				],
			],
		];

		$controls['focusInputColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Field color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.form-group input:focus',
				],
				[
					'property' => 'color',
					'selector' => '.form-group textarea:focus',
				],
			],
		];

		$controls['focusInputBorder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'border',
			'label'     => esc_html__( 'Field border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => '.form-group input:focus',
				],
				[
					'property' => 'border',
					'selector' => '.form-group textarea:focus',
				],
			],
		];

		$controls['focusInputBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Field box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => '.form-group input:focus',
				],
				[
					'property' => 'box-shadow',
					'selector' => '.form-group textarea:focus',
				],
			],
		];

		$controls['spacingSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__('Field Spacing', 'bricksultimate'),
		];

		$controls['fieldMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.comment-form .form-group',
				]
			],
		];

		$controls['fieldPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.form-group input',
				],
				[
					'property' => 'padding',
					'selector' => '.form-group textarea',
				]
			],
		];

		$controls['inputHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'number',
			'label'     => esc_html__( 'Input field height', 'bricksultimate' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => '.form-group input',
				]
			],
		];

		$controls['textareaHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'number',
			'label'     => esc_html__( 'Textarea height', 'bricksultimate' ),
			'units' 	=> true,
			'min' 		=> 50,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => '.form-group textarea',
				]
			],
		];

		//Submit button
		$controls['subBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submitButton',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => '.bricks-button',
				],
			],
		];

		$controls['subSize'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submitButton',
			'type'      => 'separator',
			'label'     => esc_html__('Sizing', 'bricksultimate'),
		];

		$controls['subWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submitButton',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => '.bricks-button',
				]
			],
		];

		$controls['subPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submitButton',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.bricks-button',
				],
			],
		];

		$controls['subHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submitButton',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['subHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'submitButton',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.bricks-button:hover',
				],
			],
		];

		$controls['subHoverColor'] = [
			'tab'   => 'content',
			'group' => 'submitButton',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.bricks-button:hover',
				],
			],
		];

		$controls['subHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'submitButton',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.bricks-button:hover',
				],
			],
		];

		$controls['subHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'submitButton',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => '.bricks-button:hover',
				],
			],
		];

		$controls['replyButtonWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'replyButton',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => '.comment-meta .comment-reply-link',
				]
			],
		];

		$controls['replyButtonPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'replyButton',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.comment-meta .comment-reply-link',
				],
			],
		];

		$controls['replyButtonBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.comment-meta .comment-reply-link',
				],
			],
		];

		$controls['replyButtonTypography'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.comment-meta .comment-reply-link',
				],
			],
		];

		$controls['replyButtonBorder'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.comment-meta .comment-reply-link',
				],
			],
		];

		$controls['replyButtonBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => '.comment-meta .comment-reply-link',
				],
			],
		];

		$controls['replyButtonHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'replyButton',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['replyButtonHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.comment-meta .comment-reply-link:hover',
				],
			],
		];

		$controls['replyButtonHoverColor'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.comment-meta .comment-reply-link:hover',
				],
			],
		];

		$controls['replyButtonHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.comment-meta .comment-reply-link:hover',
				],
			],
		];

		$controls['replyButtonHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'replyButton',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => '.comment-meta .comment-reply-link:hover',
				],
			],
		];

		return $controls;
	}
}