<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Trait\WooElementsControls;

class ProductUpCrossSells {
	use WooElementsControls;

	public function __construct() {
		add_filter( "bricks/elements/product-upsells/control_groups", [ $this, 'add_product_upcross_control_groups' ] );
		add_filter( "bricks/elements/product-upsells/controls", [ $this, 'bu_product_common_controls' ] );
	}

	/**
	 * Adds extra control group for product up/cross sells element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_product_upcross_control_groups( $control_groups ) {

		unset( $control_groups['button'] );

		$control_groups['layout'] = [
			'title' => esc_html__( 'Layout', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['button'] = [
			'title' => esc_html__( 'Button', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['title'] = [
			'title' => esc_html__( 'Title', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['price'] = [
			'title' => esc_html__( 'Price', 'bricks' ),
			'tab'   => 'content',
		];

		$newness_in_days = \Bricks\Database::get_setting( 'woocommerceBadgeNew', false );
		$badge_type = \Bricks\Database::get_setting( 'woocommerceBadgeSale', false );
		if( $badge_type ) {
			$control_groups['saleBadge'] = [
				'title' => esc_html__( 'Sale badge', 'bricksultimate' ),
				'tab'   => 'content',
			];
		}
		
		if( $newness_in_days ) {
			$control_groups['newBadge'] = [
				'title' => esc_html__( 'New badge', 'bricksultimate' ),
				'tab'   => 'content',
			];
		}

		return $control_groups;
	}
}