<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ProductsFilter {
	public function __construct() {
		add_filter( "bricks/elements/woocommerce-products-filter/control_groups", [ $this, 'add_product_filter_control_groups' ], 10, 1 );
		add_filter( "bricks/elements/woocommerce-products-filter/controls", [ $this, 'bu_enhance_product_filter_controls' ], 10, 1 );
	}

	/**
	 * Adds extra control group for post comments element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_product_filter_control_groups( $control_groups ) {
		$control_groups['resetButton'] = [
			'title' => esc_html__( 'Reset button', 'bricksultimate' ),
			'tab'   => 'content',
		];

		$control_groups['cbrd'] = [
			'title' => esc_html__( 'Checkbox / Radio', 'bricksultimate' ),
			'tab'   => 'content',
		];

		$control_groups['textList'] = [
			'title' => esc_html__( 'Text list', 'bricksultimate' ),
			'tab'   => 'content',
		];

		$control_groups['boxList'] = [
			'title' => esc_html__( 'Box list', 'bricksultimate' ),
			'tab'   => 'content',
		];

		return $control_groups;
	}

	/**
	 * Enhance the product filter element's contorls
	 * 
	 * @param array $controls keeping the all controls properties
	 * @return array $controls returning the all controls properties
	 */
	public function bu_enhance_product_filter_controls( $controls ) {
		$selector = '.reset-button';

		$controls['resetButtonWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'resetButton',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['resetButtonHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'resetButton',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['resetButtonPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'resetButton',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['resetButtonBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'resetButton',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['resetButtonHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'resetButton',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['resetButtonHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'resetButton',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['resetButtonHoverColor'] = [
			'tab'   => 'content',
			'group' => 'resetButton',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['resetButtonHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'resetButton',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];

		$controls['resetButtonHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'resetButton',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
					'important' => true
				],
			],
		];


		/**
		 * Checkbox/radio controls
		 */
		$cb_selector = 'input[type=checkbox]';
		$rd_selector = 'input[type=radio]';

		$controls['cbTypography'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' 	=> 'font',
					'selector' 	=> 'form.checkbox label'
				],
				[
					'property' 	=> 'font',
					'selector' 	=> 'form.radio label'
				],
			],
		];

		$controls['cbGap'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Gap between button & label(px)', 'bricks' ),
			'type'  => 'number',
			'unitless' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => 8,
			'css'   => [
				[
					'property' 	=> 'margin-left',
					'selector' 	=> 'form.checkbox label',
					'value' 	=> '%spx'
				],
				[
					'property' 	=> 'margin-left',
					'selector' 	=> 'form.radio label',
					'value' 	=> '%spx'
				],
			],
		];

		$controls['cbBorderRadius'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Checkbox Border Radius(px)', 'bricks' ),
			'type'  => 'number',
			'unitless' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'css'   => [
				[
					'property' 	=> 'border-radius',
					'selector' 	=> $cb_selector,
					'value' 	=> '%spx'
				],
			],
		];

		$controls['crBorderColor'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Border Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'border-color',
					'selector' => $cb_selector
				],
				[
					'property' => 'border-color',
					'selector' => $rd_selector
				],
			],
		];

		$controls['crActiveBorderColor'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Active Border Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'border-color',
					'selector' => $cb_selector . ':checked'
				],
				[
					'property' => 'border-color',
					'selector' => $rd_selector . ':checked'
				],
			],
		];

		$controls['crActiveBG'] = [
			'tab'   => 'content',
			'group' => 'cbrd',
			'label' => esc_html__( 'Active Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $cb_selector . ':checked'
				],
				[
					'property' => 'background-color',
					'selector' => $rd_selector . ':checked'
				],
			],
		];

		/**
		 * Text list controls
		 */
		$selector = '.text-list a';

		$controls['textListMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'textList',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.text-list li',
				],
			],
		];

		$controls['textListPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'textList',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.text-list li',
				],
			],
		];

		$controls['textListBG'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.text-list li'
				],
			],
		];

		$controls['textListTypography'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['textListBorder'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.text-list li'
				],
			],
		];

		$controls['textListHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'textList',
			'type'      => 'separator',
			'label'     => esc_html__('Hover state', 'bricksultimate'),
		];

		$controls['textListHoverBG'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.text-list li:hover'
				],
			],
		];

		$controls['textListHoverColor'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.text-list li a:hover'
				]
			],
		];

		$controls['textListActive'] = [
			'tab' 		=> 'content',
			'group' 	=> 'textList',
			'type'      => 'separator',
			'label'     => esc_html__('Active state', 'bricksultimate'),
		];

		$controls['textListABG'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.text-list li.current'
				],
			],
		];

		$controls['textListAColor'] = [
			'tab'   => 'content',
			'group' => 'textList',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => '.text-list li.current a'
				]
			],
		];

		/**
		 * Box list controls
		 */
		$selector = '.box-list li';

		$controls['boxListMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'boxList',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['boxListBG'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
		];

		$controls['boxListTypography'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector
				],
				[
					'property' => 'font',
					'selector' => $selector . ' label'
				],
			],
		];

		$controls['boxListBorder'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
		];

		$controls['boxListHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'boxList',
			'type'      => 'separator',
			'label'     => esc_html__('Hover state', 'bricksultimate'),
		];

		$controls['boxListHoverBG'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover'
				],
			],
		];

		$controls['boxListHoverColor'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover'
				],
				[
					'property' => 'color',
					'selector' => $selector . ':hover label'
				],
			],
		];

		$controls['boxListHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover'
				],
			],
		];

		$controls['boxListActive'] = [
			'tab' 		=> 'content',
			'group' 	=> 'boxList',
			'type'      => 'separator',
			'label'     => esc_html__('Active state', 'bricksultimate'),
		];

		$controls['boxListABG'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . '.checked'
				],
			],
		];

		$controls['boxListAColor'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . '.checked'
				],
				[
					'property' => 'color',
					'selector' => $selector . '.checked label'
				],
			],
		];

		$controls['boxListABorder'] = [
			'tab'   => 'content',
			'group' => 'boxList',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . '.checked'
				],
			],
		];

		return $controls;
	}
}