<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;
use BricksUltimate\BuAccordionMenuWalker;
use Bricks\Setup;

class AccordionMenu extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-accordion-menu';
	public $icon 			= 'ti-menu';
	public $scripts 		= [ 'buAccordionMenu' ];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Accordion Menu', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['menu_title'] = [
			'title' 	=> esc_html__( 'Menu Name', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required'	=> ['acrd_source_menu', '=', 'wpmenu']
		];

		$this->control_groups['menu_items'] = [
			'title' 	=> esc_html__( 'Menu Items', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['subitems'] = [
			'title' 	=> esc_html__( 'Sub Menu Items', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['toggle_icon'] = [
			'title' 	=> esc_html__( 'Toggle Icon', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['hover_anim'] = [
			'title' 	=> esc_html__( 'Hover Animation', 'bricksultimate' ),
			'tab' 		=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['acrd_source_menu'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Source', 'bricksultimate'),
			'options'   => [
				'wpmenu'  	=> esc_html__('WP Menu'),
				'tax'  		=> esc_html__('Taxonomy'),
			],
			'default'   => 'wpmenu',
		];

		$this->controls['acrd_menu'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('WP Menu', 'bricksultimate'),
			'options'   => Helpers::getWPMenus(),
			'default'   => 'none',
			'required'	=> ['acrd_source_menu', '=', 'wpmenu']
		];

		$this->controls['acrd_tax_name'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Taxonomy', 'bricksultimate'),
			'options'   => Setup::get_taxonomies_options(),
			'default'   => 'category',
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['include_ids'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Include terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['exclude_ids'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Exclude terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['hide_empty'] = array(
			'tab'   	=> 'content',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Hide empty terms?', 'bricksultimate' ),
			'default' 	=> true,
			'required'	=> ['acrd_source_menu', '=', 'tax']
		);

		$this->controls['child_of'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Child of', 'bricksultimate' ),
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['orderby'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Order by', 'bricksultimate'),
			'options'   => [
				'name' 			=> 'Name',
				'id' 			=> 'ID',
				'slug' 			=> 'Slug',
				'menu_order' 	=> 'Menu Order',
				'include' 		=> 'Include',
				'count' 		=> 'Count',
			],
			'default'   => 'name',
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['order'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Order', 'bricksultimate'),
			'options'   => [
				'ASC'  	=> esc_html__('ASC'),
				'DESC'  => esc_html__('DESC'),
			],
			'default'   => 'ASC',
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['limit'] = [
			'tab' 		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Limit', 'bricksultimate' ),
			'min'		=> 0,
			'max'  		=> 200,
			'step' 		=> 1,
			'medium' 	=> true,
			'inline' 	=> true,
			'unitless' 	=> true,
			'required'	=> ['acrd_source_menu', '=', 'tax']
		];

		$this->controls['isAccordion'] = [
			'tab' 		=> 'content',
			'type'      => 'checkbox',
			'label'     => esc_html__('Enable accordion effect', 'bricksultimate'),
			'reset' 	=> true
		];

		$this->controls['collapseItems'] = [
			'tab' 		=> 'content',
			'type'      => 'checkbox',
			'label'     => esc_html__('Always show the top level items', 'bricksultimate'),
			'reset' 	=> true
		];

		$this->controls['slide_toggle_td'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Slide Transition Duration', 'bricksultimate'),
			'description' => esc_html__('Unit is in milliseconds.', 'bricksultimate'),
			'min'		=> 0,
			'max'  		=> 100000,
			'step' 		=> 50,
			'default'   => 400,
			'medium' 	=> true,
			'inline' 	=> true,
			'unitless' 	=> true
		];

		//* Menu name controls
		$selector = '.bu-acrd-menu-title';
		$this->controls['display_menu_title'] = array(
			'tab'   	=> 'content',
			'group' 	=> 'menu_title',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Display Menu Name', 'bricksultimate' ),
			'default' 	=> true,
		);

		$this->controls['title_tag'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_title',
			'type'      => 'select',
			'label'     => esc_html__('Tag', 'bricksultimate'),
			'options'   => [
				'h1' 			=> 'H1',
				'h2' 			=> 'H2',
				'h3' 			=> 'H3',
				'h4' 			=> 'H4',
				'h5' 			=> 'H5',
				'h6' 			=> 'H6',
				'div' 			=> 'DIV',
			],
			'default'   => 'h4',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['title_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['titleTypography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_title',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'text-decoration',
			]
		];

		$this->controls['title_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_title',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		//margin field
		$this->controls['title_margin'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['title_padding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		//* Menu Items controls
		$selector = '.bu-menu-item-text';

		$this->controls['menu_items_padding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['menu_items_typography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['menu_items_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.menu-item a',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['menu_items_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_items',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => '.menu-item a',
					'property' => 'border',
				],
			],
		];

		$this->controls['menu_items_flexGrow'] = [
			'tab'         => 'content',
			'group' 	  => 'menu_items',
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'default' 	  => 1,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'selector' => $selector,
					'property' => 'flex-grow',
				],
			],
			'placeholder' => 1,
		];

		$this->controls['menu_items_hover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'label' 	=> esc_html__( 'Hover', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['menu_items_hbg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".menu-item a:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['menu_items_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Link Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".menu-item a:hover {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['menu_items_hborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_items',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => ".menu-item a:hover",
					'property' => 'border',
				],
			],
		];

		$this->controls['menu_items_currentItem'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'label' 	=> esc_html__( 'Current/Active Item', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['menu_items_abg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > a",
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > a",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['menu_items_aclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Link Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > a {$selector}",
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > a {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['menu_items_aborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_items',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' 	=> ".current-menu-item > a",
					'property' => 'border',
				],
				[
					'selector' 	=> ".current-menu-ancestor > a",
					'property' => 'border',
				],
			],
		];

		
		//*sub items controls
		$selector = ".bu-menu-item-text";

		$this->controls['text_indent'] = [
			'tab' 		=> 'content',
			'group' 	=> 'subitems',
			'type'      => 'number',
			'label'     => esc_html__('Text Indent for Sub Menu Items', 'bricksultimate'),
			'info' 		=> esc_html__('Unit is in px.', 'bricksultimate'),
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 5,
			'default'   => 10,
			'small' 	=> true,
			'inline' 	=> true,
			'unitless' 	=> true
		];

		$this->controls['siPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'subitems',
			'type'      => 'dimensions',
			'label'     => esc_html__('Padding', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => ".sub-menu " . $selector
				]
			]
		];

		$this->controls['siTypography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'subitems',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => ".sub-menu " . $selector
				],
			]
		];

		$this->controls['sibg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'subitems',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.sub-menu,.sub-menu .menu-item a',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['siborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'subitems',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => '.sub-menu .menu-item a',
					'property' => 'border',
				],
			],
		];

		$this->controls['sihover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'subitems',
			'label' 	=> esc_html__( 'Hover', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['sihbgclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'subitems',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".sub-menu .menu-item a:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sihclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'subitems',
			'type'      => 'color',
			'label'     => esc_html__('Link color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".sub-menu .menu-item a:hover {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sihborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_items',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => ".sub-menu .menu-item a:hover",
					'property' => 'border',
				],
			],
		];

		$this->controls['siCurItem'] = [
			'tab' 		=> 'content',
			'group' 	=> 'subitems',
			'label' 	=> esc_html__( 'Current item', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['sicurbg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'subitems',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".sub-menu .current-menu-item > a",
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".sub-menu .current-menu-ancestor > a",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sicurclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'subitems',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".sub-menu .current-menu-item > a " . $selector,
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".sub-menu .current-menu-ancestor > a " . $selector,
					'property' 	=> 'color'
				]
			]
		];

		//* Toggle icon controls
		$selector = '.bu-menu-items-arrow';

		$this->controls['arrow_icon'] = [
			'tab'     => 'content',
			'group'   => 'toggle_icon',
			'type'    => 'icon',
			'label'   => esc_html__( 'Icon', 'bricksultimate' ),
			'default' => [
				'icon'    => 'ion-ios-arrow-down',
				'library' => 'ionicons',
			],
		];

		$this->controls['icon_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group'    => 'toggle_icon',
			'label'    => esc_html__( 'Icon size & color', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			]
		];

		$this->controls['toggle_btn_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['toggle_icon_width'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'type'  	=> 'number',
			'min' 		=> 0,
			'units' 	=> true,
			'step' 		=> 1,
			'default' 	=> 50,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['_hoverItem'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Hover', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['icon_hbg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "a:hover {$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['icon_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Icon Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "a:hover {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['toggle_btn_hborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => "a:hover {$selector}",
					'property' => 'border',
				],
			],
		];

		$this->controls['_currentItem'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Current/Active Item', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['icon_abg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > a {$selector}",
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > a {$selector}",
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".bu-menu-items-arrow.acrd-menu-open",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['icon_aclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Icon Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > a {$selector}",
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > a {$selector}",
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".bu-menu-items-arrow.acrd-menu-open",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['toggle_btn_aborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' 	=> ".current-menu-item > a {$selector}",
					'property' => 'border',
				],
				[
					'selector' 	=> ".current-menu-ancestor > a {$selector}",
					'property' => 'border',
				],
				[
					'selector' 	=> ".bu-menu-items-arrow.acrd-menu-open",
					'property' => 'border',
				],
			],
		];

		$this->controls['toggle_icon_effect'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Animation', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['toggle_icon_anim'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'type'      => 'select',
			'label'     => esc_html__('Animation Type', 'bricksultimate'),
			'options'   => [
				'rotate' 	=> __('Rotate'),
				'flip' 		=> __('Vertical Flip', "oxy-ultimate")
			],
			'default'   => 'flip',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['toggle_icon_rotate'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'type'      => 'number',
			'label'     => esc_html__('Initial Transform Rotate(deg)', 'bricksultimate'),
			'unit' 		=> 'deg',
			'min'		=> -180,
			'max'  		=> 180,
			'step' 		=> 5,
			'default'   => 0,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . "::before",
					'property' 	=> 'transform:rotate'
				]
			]
		];

		$this->controls['icon_rotate_open'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'type'      => 'number',
			'label'     => esc_html__('Active Transform Rotate(deg)', 'bricksultimate'),
			'unit' 		=> 'deg',
			'min'		=> -180,
			'max'  		=> 180,
			'step' 		=> 5,
			'default'   => 45,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-menu-items-arrow.acrd-menu-open::before',
					'property' 	=> 'transform:rotate'
				]
			],
			'required' 	=> [ 'toggle_icon_anim', '=', 'rotate' ]
		];

		$this->controls['toggle_icon_td'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'type'      => 'number',
			'label'     => esc_html__('Transition Duration(sec)', 'bricksultimate'),
			'unit' 		=> 's',
			'min'		=> 0,
			'max'  		=> 10,
			'step' 		=> .1,
			'default'   => 0.4,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'transition-duration'
				]
			]
		];

		//* Hover animation controls
		$this->controls['link_td'] = [
			'tab' 		=> 'content',
			'group' 	=> 'hover_anim',
			'type'      => 'number',
			'label'     => esc_html__('Transition Speed(sec)', 'bricksultimate'),
			'unit' 		=> 's',
			'min'		=> 0,
			'max'  		=> 10,
			'step' 		=> .1,
			'default'   => 0.4,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.menu-item a',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '.bu-menu-items-arrow',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '.bu-menu-item-text',
					'property' 	=> 'transition-duration'
				]
			]
		];

		$this->controls['slide_left'] = [
			'tab' 		=> 'content',
			'group' 	=> 'hover_anim',
			'type'      => 'number',
			'label'     => esc_html__('Slide to Right', 'bricksultimate'),
			'info' 		=> esc_html__('How much slide from left. Disable: enter 0.', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 50,
			'step' 		=> 1,
			'default'   => 10,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> '--menu-item-translatex'
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-accordion-menu', Helpers::get_asset_url('css') . 'accordionmenu.min.css', [], filemtime(Helpers::get_asset_path('css') . 'accordionmenu.min.css'), 'all' );
		}*/
		wp_enqueue_script( 'bu-accordion-menu', Helpers::get_asset_url('js') . 'accordionmenu.min.js', [], filemtime(Helpers::get_asset_path('js') . 'accordionmenu.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$menuSource 	= Helpers::get_value( $settings, 'acrd_source_menu', 'wpmenu' );
		$text_indent 	= Helpers::get_value( $settings, 'text_indent', 10 );
		$toggleDuration = Helpers::get_value( $settings, 'slide_toggle_td', 400 );
		$datattr[] 		= 'data-acrd-toggle-duration="' . intval($toggleDuration) . '"';
		$datattr[] 		= 'data-acrd-effect="' . ( !empty($settings['isAccordion']) ? 'yes' : 'no' ) . '"';
		$datattr[] 		= 'data-acrd-collapsed="' . ( !empty($settings['collapseItems']) ? 'yes' : 'no' ) . '"';
		
		$toggle_icon_anim = Helpers::get_value( $settings, 'toggle_icon_anim', 'flip' );
		$this->set_attribute( '_root', 'class', 'bu-acrd-arrow-' . $toggle_icon_anim );
		
		// Icon
		$icon_html 		= '';
		if ( isset( $settings['arrow_icon'] ) ) {
			$icon_html = self::render_icon( $settings['arrow_icon'], [ 'icon bu-menu-items-arrow' ] );
		}

		$GLOBALS[ 'arrow_btn' ] = $icon_html;

		echo "<div {$this->render_attributes('_root')}>";

		if( $menuSource == 'wpmenu' ) {
			$acrd_menu = Helpers::get_value( $settings, 'acrd_menu', 'none');
			if( $acrd_menu == 'none' || $acrd_menu == 'nomenu' ) {
				return $this->render_element_placeholder( ['title' => esc_html__( 'Select a menu.', 'bricksultimate' )] );
			}

			$display_title = ! empty( $settings['display_menu_title'] ) ? true : false;
			if( $display_title ) {
				$tag = Helpers::get_value( $settings, 'title_tag', 'h4');
				echo '<' . $tag . ' class="bu-acrd-menu-title">'. wp_get_nav_menu_object($acrd_menu)->name . '</' . $tag .'>';
			}

			$args = array(
				'echo'        => false,
				'menu'        => $acrd_menu,
				'menu_class'  => 'bu-acrd-menu-items',
				'menu_id'     => 'menu-' . $this->id,
				'link_before' => '<span itemprop="name" class="bu-menu-item-text">', //#MENUICON#
				'link_after'  => '</span>' . $icon_html,
				'container'   => '',
				'text_indent' => absint( $text_indent )
			);

			add_filter( 'nav_menu_item_args', array( $this, 'bu_acrd_menu_items_args'), 10, 3 );
			add_filter( 'nav_menu_link_attributes', array( $this, 'bu_acrdmenu_link_attributes' ), 10, 4 );

			$menu = '<nav '. implode(" ", $datattr) .'>';
			$menu .= wp_nav_menu( $args );
			$menu .= '</nav>';

			echo $menu;

			remove_filter( 'nav_menu_link_attributes', array( $this, 'bu_acrdmenu_link_attributes' ), 10, 4 );
			remove_filter( 'nav_menu_item_args', array( $this, 'bu_acrd_menu_items_args'), 10, 3 );
		}

		/**
		 * Taxonomy
		 */
		if( $menuSource == 'tax' ) {
			$menu = '<nav '. implode(" ", $datattr) .'>';
			$menu .= '<ul id="menu-' . $this->id .'" class="bu-acrd-menu-items">';

			$taxonomy = Helpers::get_value( $settings, 'acrd_tax_name', 'category' );

			$args = array(
				'show_option_all'    => '',
				'style'              => 'list',
				'show_count'         => 0,
				'hide_empty'         => 1,
				'hierarchical'       => 1,
				'title_li'           => '',
				'show_option_none'   => '',
				'number'             => null,
				'echo'               => 0,
				'depth'              => 0,
				'current_category'   => 0,
				'pad_counts'         => 0,
				'taxonomy'           => $taxonomy,
				'text_indent' 		 => $text_indent,
				'walker'             => new BuAccordionMenuWalker,
			);

			$include_ids = Helpers::get_value( $settings, 'include_ids', false );
			if( $include_ids ) {
				$args['include'] = array_filter( array_map( 'trim', explode( ',', $include_ids ) ) );
			}

			$exclude_ids = Helpers::get_value( $settings, 'exclude_ids', false );
			if( $exclude_ids ) {
				$args['exclude'] = array_filter( array_map( 'trim', explode( ',', $exclude_ids ) ) );
			}

			$child_of = Helpers::get_value( $settings, 'child_of', false );
			if( $child_of ) {
				$args['child_of'] = absint( $child_of );
			}

			$limit = Helpers::get_value( $settings, 'limit', false );
			if( $limit ) {
				$args['number'] = absint( $limit );
			}

			$args['hide_empty'] = ! empty( $settings['hide_empty'] ) ? true : false;
			$args['orderby'] = Helpers::get_value( $settings, 'orderby', "name");
			$args['order'] = Helpers::get_value( $settings, 'order', "ASC");

			$menu .= wp_list_categories( $args );

			$menu .= '</ul></nav>';

			echo $menu;
		}

		echo "</div>";
	}

	public function bu_acrd_menu_items_args( $args, $item, $depth ) {
		global $arrow_btn;

		$rp_item = '<span style="margin-left:' . ( $depth * $args->text_indent ). 'px;"';

		$args->link_before = str_replace( '<span', $rp_item, $args->link_before );

		return $args;
	}

	public function bu_acrdmenu_link_attributes( $atts, $item, $args, $depth ) {
		$atts['itemprop'] = 'url';
		if( isset( $item->title ) ) {
			$atts['data-title'] = esc_attr( $item->title );
		}

		return $atts;
	}
}