<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, BuAjaxSearchCategoryWalker};
use BricksUltimate\Trait\LayoutControls;

class AjaxSearch extends \Bricks\Element {
	use LayoutControls;

	public $category = 'ultimate';
	public $name 	= 'bu-ajax-search';
	public $icon 	= 'ti-search';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Ajax Search Form', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['form'] = [
			'title' 	=> esc_html__( 'Form', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['search_field'] = [
			'title' 	=> esc_html__( 'Search field', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['search_cat'] = [
			'title' 	=> esc_html__( 'Category', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['hasCat', '=', true]
		];

		$this->control_groups['meta_query'] = [
			'title' 	=> esc_html__( 'Filter by Meta', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['search_btn'] = [
			'title' 	=> esc_html__( 'Search button', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['hasSearchBtn', '=', true]
		];

		$this->control_groups['search_close'] = [
			'title' 	=> esc_html__( 'Reset button', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['search_rslt'] = [
			'title' 	=> esc_html__( 'Search result', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['viewall_btn'] = [
			'title' 	=> esc_html__( 'View all button', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {

		$this->controls['info'] = [
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Refresh the builder editor for the correct preview.', 'bricksultimate' ),
		];

		$this->controls['layout'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Layout', 'bricks' ),
			'options'     => [
				'default' 	=> esc_html__('Default', 'bricks'),
				'skin-1' 	=> esc_html__('Category-input-icon', 'bricks'),
			],
			'placeholder' => esc_html__( 'Default', 'bricksultimate' ),
			'rerender' => true
		];

		$this->controls['postType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricksultimate' ),
			'default' 	=> 'post',
			'rerender' => true
		];

		$this->controls['scrollThumbBg'] = [
			'label'    => esc_html__( 'Scrollbar thumb background', 'bricksultimate' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => '--scrollbar-thumb-bg'
				],
			],
			'rerender' => false
		];

		$this->controls['scrollTrackBg'] = [
			'label'    => esc_html__( 'Scrollbar track background', 'bricksultimate' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => '--scrollbar-track-bg'
				],
			],
			'rerender' => false
		];

		$this->controls['hasCat'] = [
			'type'	=> 'checkbox',
			'label' => esc_html__( 'Enable category field', 'bricksultimate' ),
			'reset' => true,
		];

		$this->controls['hasSearchBtn'] = [
			'type'	=> 'checkbox',
			'label' => esc_html__( 'Enable search button', 'bricksultimate' ),
			'reset' => true,
			'default' => true
		];

		/**
		 * Form section
		 * -----------------------*/

		$this->controls['form_label'] = [
			'group' => 'form',
			'type'	=> 'text',
			'label' => esc_html__( 'Aria label', 'bricksultimate' ),
			'placeholder' => esc_html__('Ajax search form', 'bricks')
		];

		$this->controls['inline_pad'] = [
			'group' => 'form',
			'type'	=> 'number',
			'label' => esc_html__( 'Inline padding', 'bricksultimate' ),
			'units' => true,
			'inline' => true,
			'placeholder' => '10px',
			'css' => [
				[
					'property' => 'padding-inline'
				]
			]
		];

		$this->controls['form_height'] = [
			'group' => 'form',
			'type'	=> 'number',
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'units' => true,
			'inline' => true,
			'placeholder' => '40px',
			'css' => [
				[
					'property' => '--bu-as-form-height'
				]
			]
		];

		//* Input field
		$selector = '.search-form input[type="text"]';

		$this->controls['form_border'] = [
			'group' => 'form',
			'type'	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'border'
				]
			],
			'rerender' => false
		];

		$this->controls['form_fborder'] = [
			'group' => 'form',
			'type'	=> 'border',
			'label' => esc_html__( 'Border - Focus', 'bricksultimate' ),
			'css' => [
				[
					'selector' => $selector . ':focus',
					'property' => 'border'
				]
			],
			'rerender' => false
		];

		$this->controls['inpf_text'] = [
			'group' => 'search_field',
			'type'	=> 'text',
			'label' => esc_html__( 'Placeholder text', 'bricksultimate' ),
			'placeholder' => esc_html__('Search for products', 'bricksultimate')
		];

		$this->controls['inpf_label'] = [
			'group' => 'search_field',
			'type'	=> 'text',
			'label' => esc_html__( 'Aria label', 'bricksultimate' ),
			'placeholder' => esc_html__('Search', 'bricks')
		];

		$this->controls['inpf_width'] = [
			'group' => 'search_field',
			'type'	=> 'number',
			'label' => esc_html__( 'Min. width', 'bricksultimate' ),
			'units' => true,
			'inline' => true,
			'placeholder' => '290px',
			'css' => [
				[
					'selector' => $selector,
					'property' => 'min-width'
				]
			],
			'rerender' => false
		];

		$this->controls['inpf_tg'] = [
			'group' => 'search_field',
			'type'	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'font'
				]
			],
			'rerender' => false
		];

		$this->controls['inpf_placeholder'] = [
			'group' => 'search_field',
			'type'	=> 'typography',
			'label' => esc_html__( 'Placeholder', 'bricksultimate' ),
			'css' => [
				[
					'selector' => "::placeholder",
					'property' => 'font'
				]
			],
			'rerender' => false
		];

		//* Category dropdown
		$this->controls['builderPreview'] = array(
			'group' 	=> 'search_cat',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Dropdown preview', 'bricksultimate' ),
			'description' 	=> esc_html__( 'Dropdown preview in the builder editor', 'bricksultimate' ),
		);

		$this->controls['catArgsSep'] = [
			'group' 	=> 'search_cat',
			'type'      => 'separator',
		];

		$this->controls['argsInfo'] = [
			'group' 	=> 'search_cat',
			'type'      => 'info',
			'content' 	=> esc_html__('Setup terms query arguments for the wp_list_categories() function.', 'bricksultimate')
		];

		$this->controls['taxonomy'] = [
			'group' 	=> 'search_cat',
			'type'      => 'select',
			'label'     => esc_html__('Taxonomy', 'bricks'),
			'options'   => \Bricks\Setup::get_taxonomies_options(),
			'default'   => 'category',
			'rerender'  => true
		];

		$this->controls['hide_empty'] = array(
			'group' 	=> 'search_cat',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Hide empty terms?', 'bricksultimate' ),
			'default' 	=> true
		);

		$this->controls['child_of'] = [
			'group' 	=> 'search_cat',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Child of', 'bricksultimate' ),
			'inline' 	=> true,
		];

		$this->controls['depth'] = [
			'group' 	=> 'search_cat',
			'type' 		=> 'number',
			'unitless' 	=> true,
			'label' 	=> esc_html__( 'Depth', 'bricksultimate' ),
			'inline' 	=> true,
			'placeholder' => 0
		];

		$this->controls['include_ids'] = [
			'group' 	=> 'search_cat',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Include terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'medium' 	=> true,
			'inline' 	=> true
		];

		$this->controls['exclude_ids'] = [
			'group' 	=> 'search_cat',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Exclude terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'medium' 	=> true,
			'inline' 	=> true
		];

		$this->controls['orderby'] = [
			'group' 	=> 'search_cat',
			'type'      => 'select',
			'label'     => esc_html__('Order by', 'bricksultimate'),
			'options'   => [
				'name' 			=> 'Name',
				'id' 			=> 'ID',
				'slug' 			=> 'Slug',
				'menu_order' 	=> 'Menu Order',
				'include' 		=> 'Include',
				'count' 		=> 'Count',
			],
			'default'   => 'name',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['order'] = [
			'group' 	=> 'search_cat',
			'type'      => 'select',
			'label'     => esc_html__('Order', 'bricksultimate'),
			'options'   => [
				'ASC'  	=> esc_html__('ASC'),
				'DESC'  => esc_html__('DESC'),
			],
			'default'   => 'ASC',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['catBtnSep'] = [
			'group' 	=> 'search_cat',
			'type'      => 'separator',
			'label'     => esc_html__('Button', 'bricksultimate'),
		];

		$this->controls['catInPad'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Inline padding', 'bricksultimate' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'placeholder' => '15px',
			'css' 		=> [
				[
					'property' => 'padding-inline',
					'selector' => '.bu-as-cat > a'
				],
			],
			'rerender' => false
		];

		$this->controls['catBtnW'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'placeholder' => '175px',
			'css' 		=> [
				[
					'property' => '--bu-as-form-cat-w',
					'selector' => ''
				],
			],
			'rerender' => false
		];

		$this->controls['catBg'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Background', 'bricksultimate' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.bu-as-cat > a'
				]
			],
			'rerender' => false
		];

		$this->controls['catBorder'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'type' 		=> 'border',
			'css' 		=> [
				[
					'property' => 'border',
					'selector' => '.bu-as-cat > a'
				]
			],
			'rerender' => false
		];

		$this->controls['optionText'] = [
			'group' 	=> 'search_cat',
			'type'      => 'text',
			'label'     => esc_html__('Placeholder text', 'bricksultimate'),
			'placeholder'  => esc_html__('Select category')
		];

		$this->controls['optionTextTg'] = [
			'group' 	=> 'search_cat',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricksultimate'),
			'css'  		=> [
				[
					'selector' => '.bu-as-cat > a > span',
					'property' => 'font'
				]
			],
			'rerender' => false
		];

		/**
		 * Category dropdown arrow
		 -------------------------------*/
		$this->controls['arrowIcon'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__('Arrow icon', 'bricksultimate'),
			'type' 		=> 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-angle-down',
			]
		];

		$this->controls['arrowSize'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Arrow size', 'bricksultimate' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'required' 	=> [ 'arrowIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-as-dd--icon'
				],
			],
			'rerender' => false
		];

		$this->controls['arrowColor'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Arrow color', 'bricksultimate' ),
			'type' 		=> 'color',
			'required' 	=> [ 'arrowIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '.bu-as-dd--icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-as-dd--icon'
				],
			],
			'rerender' => false
		];

		$this->controls['arrowTD'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Transition duration(rotate)', 'bricksultimate' ),
			'type'     => 'number',
			'unitless' => false,
			'placeholder' 	=> 0.3,
			'css'      => [
				[
					'property' => 'transition-duration',
					'selector' => '.bu-as-dd--icon',
					'value' => '%ss'
				],
			],
			'rerender' => false
		];


		/**
		 * Category dropdown container
		 -------------------------------*/
		$this->controls['catContentSep'] = [
			'group' 	=> 'search_cat',
			'type'      => 'separator',
			'label'     => esc_html__('Content container', 'bricksultimate'),
		];

		$selector = ".bu-as-cat-dropdown";

		$this->controls['containerPad'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'type' 		=> 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
			'rerender' => false
		];

		$this->controls['containerWidth'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'width',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerHeight'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'height',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerMaxHeight'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Max. Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '50vh',
			'css'      => [
				[
					'property' => 'max-height',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerBg'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Background', 'bricksultimate' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
			'rerender' => false
		];

		$this->controls['containerBrd'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'type' 		=> 'border',
			'css' 		=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
			'rerender' => false
		];

		$this->controls['containerBS'] = [
			'group' 	=> 'search_cat',
			'label' 	=> esc_html__( 'Box shadow', 'bricksultimate' ),
			'type' 		=> 'box-shadow',
			'css' 		=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
			'rerender' => false
		];

		$this->controls['containerPosRight'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Position: right', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerPosLeft'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Position: left', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerPosT'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Position: top', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['containerPosB'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Position: bottom', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'bottom',
					'selector' => $selector
				],
			],
			'rerender' => false
		];


		/**
		 * Terms list
		 -------------------------------*/
		$this->controls['termsSep'] = [
			'group' 	=> 'search_cat',
			'type'      => 'separator',
			'label'     => esc_html__('Terms List', 'bricksultimate'),
		];

		$this->controls['termsTg'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.bu-as-cat-dropdown ul li a'
				],
			],
			'rerender' => false
		];

		$this->controls['termsHcolor'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-as-cat-dropdown ul li a:hover'
				],
			],
			'rerender' => false
		];

		$this->controls['termsActive'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Active term', 'bricksultimate' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.bu-as-cat-dropdown .current-item > a'
				],
			],
			'rerender' => false
		];

		$this->controls['termsSpacing'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Spacing', 'bricks' ),
			'type'     => 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => '.bu-as-cat-dropdown ul li a'
				],
			],
			'rerender' => false
		];

		$this->controls['termsIndent'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Text indent(sub items)', 'bricksultimate' ),
			'type'     => 'number',
			'units' 	=> true,
			'placeholder' => '15px',
			'css'      => [
				[
					'property' => 'padding-left',
					'selector' => '.bu-as-cat-dropdown .children li a'
				],
			],
			'rerender' => false
		];

		$this->controls['termsTransition'] = [
			'group' 	=> 'search_cat',
			'label'    => esc_html__( 'Transition', 'bricksultimate' ),
			'type'     => 'text',
			'placeholder' 	=> 'color 0.3s ease',
			'css'      => [
				[
					'property' => 'transition',
					'selector' => '.bu-as-cat-dropdown li > a'
				],
			],
			'rerender' => false
		];

		/**
		 * Meta query
		 ----------------------------------------------------------- */
		 $this->controls['mqRelation'] = [
			'group' 	=> 'meta_query',
			'label' 	=> esc_html__( 'Relation', 'bricks' ),
			'type' 		=> 'select',
			'options' 	=> [
				'OR' 	=> esc_html__('OR'),
				'AND' 	=> esc_html__('AND')
			],
			'rerender' 	=> false,
			'inline' 	=> true,
			'placeholder' 	=> 'OR',
			'default' 	=> 'OR'
		];

		$this->controls['metaQuery'] = [
			'group' 		=> 'meta_query',
			'placeholder'   => esc_html__( 'Meta query', 'bricksultimate' ),
			'type'          => 'repeater',
			'titleProperty' => 'key',
			'fields'        => [
				'key' => [
					'label'     => esc_html__( 'Meta key', 'bricksultimate' ),
					'type'      => 'text',
					'hasDynamicData' => false,
				],

				'compare' => [
					'label'     => esc_html__( 'Compare', 'bricksultimate' ),
					'type'      => 'select',
					'options' 	=> [
						'=' 		=> esc_html__('Equal'),
						'!=' 		=> esc_html__('Not equal'),
						'>' 		=> esc_html__('Greater than'),
						'>=' 		=> esc_html__('Greater than or equal'),
						'<' 		=> esc_html__('Lesser'),
						'<=' 		=> esc_html__('Lesser or equal'),
						'LIKE'		=> esc_html__('LIKE'), 
						'NOT LIKE' 	=> esc_html__('NOT LIKE'), 
						'IN' 		=> esc_html__('IN'), 
						'NOT IN' 	=> esc_html__('NOT IN'), 
						'BETWEEN' 	=> esc_html__('BETWEEN'), 
						'NOT BETWEEN' => esc_html__('NOT BETWEEN'), 
						'EXISTS' 	=> esc_html__('EXISTS'),
						'NOT EXISTS' => esc_html__('NOT EXISTS'),
					],
					'rerender' 	=> false,
					'default' 	=> '=',
				],
				
				'type' => [
					'label'     => esc_html__( 'Type', 'bricksultimate' ),
					'type'      => 'select',
					'options' 	=> [
						'NUMERIC' 	=> esc_html__('NUMERIC'),
						'BINARY' 	=> esc_html__('BINARY'),
						'CHAR' 		=> esc_html__('CHAR'),
						'DATE' 		=> esc_html__('DATE'),
						'DATETIME' 	=> esc_html__('DATETIME'),
						'DECIMAL' 	=> esc_html__('DECIMAL'),
						'SIGNED'	=> esc_html__('SIGNED'), 
						'TIME' 		=> esc_html__('TIME'), 
						'UNSIGNED' 	=> esc_html__('UNSIGNED'),
					],
					'rerender' 	=> false,
					'default' 	=> 'CHAR',
				],
			],
		];

		//* Search button section
		$this->controls['btnArialabel'] = [
			'group' => 'search_btn',
			'type'	=> 'text',
			'label' => esc_html__( 'Aria label', 'bricksultimate' ),
			'placeholder' => esc_html__('Label', 'bricks')
		];

		$this->controls['buttonWidth'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '40px',
			'css'      => [
				[
					'property' => '--bu-as-form-btn-w'
				],
			],
			'rerender' => false
		];

		$this->controls['buttonHeight'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '100%',
			'css'      => [
				[
					'property' => 'height',
					'selector' => '.search-submit'
				],
			],
			'rerender' => false
		];

		$this->controls['buttonPT'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Position: Top', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => '.search-submit'
				],
			],
			'rerender' => false
		];

		$this->controls['buttonPR'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Position: Right', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => '.search-submit'
				],
			],
			'rerender' => false
		];

		$this->controls['buttonPB'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Position: Bottom', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'bottom',
					'selector' => '.search-submit'
				],
			],
			'rerender' => false
		];

		$this->controls['buttonPL'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Position: Left', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => '.search-submit'
				],
			],
			'rerender' => false
		];

		$this->controls['searchIconSep'] = [
			'group' 	=> 'search_btn',
			'type' 		=> 'separator',
		];

		$this->controls['searchIcon'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__('Icon', 'bricksultimate'),
			'type' 		=> 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-search',
			]
		];

		$this->controls['iconSize'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'required' 	=> [ 'searchIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-as-search-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['searchBtnBG'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__( 'Background color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'searchIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.search-button'
				]
			],
			'rerender' => false
		];

		$this->controls['searchIconColor'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__( 'Color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'searchIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '.bu-as-search-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-as-search-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['searchBtnHBG'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__( 'Hover background color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'searchIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.search-button:hover'
				]
			],
			'rerender' => false
		];

		$this->controls['searchIconHColor'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__( 'Hover color', 'bricks' ),
			'type' 		=> 'color',
			'units' 	=> true,
			'required' 	=> [ 'searchIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '.bu-as-search-icon:hover'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-as-search-icon:hover'
				],
			],
			'rerender' => false
		];

		$this->controls['searchLISep'] = [
			'group' 	=> 'search_btn',
			'type' 		=> 'separator',
		];

		$this->controls['loadingIcon'] = [
			'group' 	=> 'search_btn',
			'label' 	=> esc_html__('Loading icon', 'bricksultimate'),
			'type' 		=> 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-control-record',
			],
			'rerender' => false
		];

		$this->controls['loadingIconSize'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Loading icon size', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ 'loadingIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.loading-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['loadingIconColor'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Loading icon color', 'bricksultimate' ),
			'type'     => 'color',
			'required' => [ 'loadingIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.loading-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.loading-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['searchASep'] = [
			'group' 	=> 'search_btn',
			'type' 		=> 'separator',
		];

		$this->controls['buttonArrow'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Enable arrow', 'bricks' ),
			'type'     => 'checkbox',
		];

		$this->controls['buttonArrowWidth'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Arrow width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '7px',
			'css'      => [
				[
					'property' => '--btn-arrow-size',
				],
			],
			'rerender' => false,
			'required' =>['buttonArrow', '=', true]
		];

		$this->controls['buttonArrowColor'] = [
			'group' 	=> 'search_btn',
			'label'    => esc_html__( 'Arrow color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => '--btn-arrow-color',
				],
			],
			'rerender' => false,
			'required' =>['buttonArrow', '=', true]
		];

		/**
		 * Search reset button
		 -------------------------------*/
		 $this->controls['resetWidth'] = [
			'group' 	=> 'search_close',
			'label'    => esc_html__( 'Width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '40px',
			'css'      => [
				[
					'property' => '--bu-as-reset-btn-w',
					'selector' => '&.has-reset-btn'
				],
			],
			'rerender' => false
		];

		$this->controls['resetIcon'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__('Icon', 'bricksultimate'),
			'type' 		=> 'icon',
		];

		$this->controls['rstIconSize'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'required' 	=> [ 'resetIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-as-reset-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['searchrBtnBG'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__( 'Background color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'resetIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.search-reset-button'
				]
			],
			'rerender' => false
		];

		$this->controls['searchrIconColor'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__( 'Color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'resetIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '.bu-as-reset-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-as-reset-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['searchrBtnHBG'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__( 'Hover background color', 'bricks' ),
			'type' 		=> 'color',
			'required' 	=> [ 'resetIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.search-reset-button:hover'
				]
			],
			'rerender' => false
		];

		$this->controls['searchrIconHColor'] = [
			'group' 	=> 'search_close',
			'label' 	=> esc_html__( 'Hover color', 'bricks' ),
			'type' 		=> 'color',
			'units' 	=> true,
			'required' 	=> [ 'resetIcon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '.search-reset-button:hover .bu-as-reset-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.search-reset-button:hover .bu-as-reset-icon'
				],
			],
			'rerender' => false
		];
		

		/**
		 * Search result section
		 -------------------------------*/
		 $this->controls['rsbBuilderPreview'] = [
		 	'group' => 'search_rslt',
			'type'	=> 'checkbox',
			'label' => esc_html__( 'Preview In-Builder', 'bricksultimate' )
		];

		$this->controls['templates'] = [
		 	'group' 		=> 'search_rslt',
			'type' 			=> 'repeater',
			'placeholder' 	=> esc_html__( 'Search Results template', 'bricksultimate' ),
			'titleProperty' => 'template',
			'fields'      => [
				'type' 	=> [
					'label' 	=> esc_html__( 'Query type', 'bricksultimate' ),
					'type'  	=> 'select',
					'options' 	=> ['post' => 'Posts', 'term' => 'Terms' ],
					'default' 	=> 'post'
				],
				'rsPostType' => [
					'type'        => 'select',
					'label'       => esc_html__( 'Post type', 'bricks' ),
					'options'     => \Bricks\Helpers::get_registered_post_types(),
					'multiple'    => false,
					'placeholder' => esc_html__( 'Select post type', 'bricksultimate' ),
					'default' 	=> 'post'
				],
				'template'    => [
					'label' => esc_html__( 'Template', 'bricks' ),
					'type'  => 'select',
					'options'     => \Bricks\Templates::get_templates_list('bu_as_result'),
					'multiple'    => false,
					'placeholder' => esc_html__( 'Select a template', 'bricks' ),
				],
			]
		];

		$selector = '.bu-as-result-wrapper';

		$this->controls['resultWrapperSep'] = [
			'group' => 'search_rslt',
			'label' => esc_html__( 'Content Wrapper', 'bricksultimate' ),
			'type' 	=> 'separator',
		];

		$this->controls['resultWrapperBG'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Background', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperBrd'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperBS'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Box shadow', 'bricks' ),
			'type'     => 'box-shadow',
			'css'      => [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperW'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => 'calc(100% - 20px)',
			'css'      => [
				[
					'property' => 'width',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperH'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => '--content-wrapper-height',
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperMH'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Max. Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'placeholder' => '50vh',
			'css'      => [
				[
					'property' => '--content-wrapper-mheight',
				],
			],
			'rerender' => false
		];

		$this->controls['resultWrapperPad'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Padding', 'bricks' ),
			'type'     => 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['rsltPosRight'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Position: right', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['rsltPosLeft'] = [
			'group' 	=> 'search_rslt',
			'label'    => esc_html__( 'Position: left', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$controls['zIndex'] = [
			'group' 	=> 'search_rslt',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__( 'z-index', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'z-index',
					'selector' => $selector,
				]
			],
		];

		$this->controls['containerLayoutSep'] = [
			'group' => 'search_rslt',
			'label' => esc_html__( 'Content Layout', 'bricksultimate' ),
			'type' 	=> 'separator',
		];

		$this->controls = array_merge( $this->controls, $this->bu_layout_settings([], 'search_rslt', '.autocomplete-suggestions', true ) );

		/**
		 * View All button
		 * -----------------------*/
		$this->controls['vaBtnSelector'] = [
			'group' => 'viewall_btn',
			'label' => esc_html__( 'Button selector', 'bricksultimate' ),
			'type' 	=> 'text',
			'placeholder' => '.brxe-button',
			'description' => esc_html__('Create a view all button in the search result template and put the selector here.', 'bricksultimate')
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-ajax-search', Helpers::get_asset_url('css') . 'ajaxsearch.min.css', [], filemtime(Helpers::get_asset_path('css') . 'ajaxsearch.min.css'), 'all' );
		} else {*/
			wp_enqueue_script( 'bu-ajax-search', Helpers::get_asset_url('js') . 'ajaxsearch.min.js', ['jquery'], filemtime(Helpers::get_asset_path('js') . 'ajaxsearch.min.js'), true );
		//}
	}

	public function render() {
		$settings = $this->settings;

		if ( empty( $settings['postType'] ) ) {
			return $this->render_element_placeholder(
				[
					'title' => esc_html__( 'Select correct post type.', 'bricksultimate' ),
				]
			);
		}

		$postType = Helpers::get_value($settings, 'postType', 'post');

		$templates = ! empty( $settings['templates'] ) ? $settings['templates'] : false;

		$data = [
			'postType' 	=> $postType,
			'hasCat' 	=> ! empty( $settings['hasCat'] ),
			'taxonomy' 	=> Helpers::get_value($settings, 'taxonomy', 'category'),
			'viewAllBtn' => Helpers::get_value($settings, 'vaBtnSelector', 'no'),
		];

		if( isset( $settings['metaQuery'] ) ) {
			$data['relation'] = Helpers::get_value($settings, 'mqRelation', 'OR');
			$data['meta_query'] = $settings['metaQuery'];
		}

		if( $templates ) {
			$tpls = [];
			foreach ( $templates as $index => $template ) {
				$type = $template['type'] ?? 'post';
				if( $type == 'post' ) {
					$rsPostType = $template['rsPostType'] ?? 'post';
					$tpls[ $type ][] = "{$rsPostType}_" . ( $template['template'] ?? 'none' );
				} else {
					$tpls[ $type ][] = $template['template'] ?? 'none';
				}
			}

			$data['template'] = $tpls;
		}

		$this->set_attribute("_root", "data-buas-config", wp_json_encode( $data ) );

		$this->set_attribute("_root", "class", [ Helpers::get_value($settings, 'layout', 'default') ]);

		//* reset button
		if( ! empty( $settings['resetIcon'] ) ) {
			$this->set_attribute("_root", "class", [ 'has-reset-btn' ]);
		}

		//* category dropdown
		if( ! empty( $settings['hasCat'] ) ) {
			$this->set_attribute("_root", "class", [ 'has-cat' ]);
		}

		//* search button
		if( ! empty( $settings['hasSearchBtn'] ) ) {
			$this->set_attribute("_root", "class", [ 'has-search-btn' ]);
		}

		echo "<{$this->tag} {$this->render_attributes("_root")}>";

		//* search form
		echo '<form role="search" class="searchform search-form" aria-label="Ajax search form" method="get" action="'. esc_url( home_url('/') ) . '">';

		echo "<label class=\"screen-reader-text hide\" for=\"s\">" . esc_attr_x('Search for:', 'bricks') . "</label>";
		echo "<input type=\"hidden\" name=\"post_type\" value=\"{$postType}\"/>";

		echo '<input type="text" class="search-field s" aria-label="' . Helpers::get_value( $settings, 'inpf_label', esc_attr_x( 'Search', 'bricks' ) ) . '" placeholder="' . Helpers::get_value( $settings, 'inpf_text', esc_attr_x( 'Search &hellip;', 'bricks' ) ) . '" value="' . get_search_query() . '" title="' . Helpers::get_value( $settings, 'inpf_text', esc_attr_x( 'Search &hellip;', 'bricks' ) ) . '" name="s" required/>';


		//* reset button
		if( ! empty( $settings['resetIcon'] ) ) {
			$this->set_attribute("bu-ajax-search-reset-button", "class", ['search-reset-button']);

			echo "<span {$this->render_attributes("bu-ajax-search-reset-button")}>";
			echo self::render_icon( $settings['resetIcon'], ['bu-as--icon bu-as-reset-icon'] );
			echo "</span>";
		}

		//* category dropdown
		if( ! empty( $settings['hasCat'] ) ) {
			$this->getTermsDropdown( $settings );
		}

		//* search button
		if( ! empty( $settings['hasSearchBtn'] ) ) {
			$this->getSearchButton( $settings );
		}

		echo "</form>";

		//* search result
		if( $templates ) {
			$this->set_attribute("bu-as-result", "class", ['bu-as-result-wrapper']);

			if( ( ! empty($settings['rsbBuilderPreview']) || ! empty($settings['btnBuilderPreview']) ) && Helpers::isBricksBuilderActive() ) {
				$this->set_attribute("bu-as-result", "class", ['result-opened']);
			}

			echo "<div {$this->render_attributes('bu-as-result')}><div class=\"bu-as-result-content\">";
				if( Helpers::isBricksBuilderActive() && $templates ) {
					echo "<div class='autocomplete-suggestions'>";
					foreach ( $templates as $index => $template ) {
						if( isset( $template['template'] ) ) {
							echo "<div class='autocomplete-suggestion'>";
							echo do_shortcode('[bricks_template id="'. $template['template'] . '"]');
							echo "</div>";
						}
					}
					echo "</div>";
				}
			echo "</div></div>";
		}

		echo "</{$this->tag}>";
	}

	public function getTermsDropdown( $settings ) {
		$args = array( 
			'hide_empty' 	=> ! empty( $settings['hide_empty'] ),
			'parent' 		=> Helpers::get_value( $settings, 'child_of', 0)
		);
		
		$taxonomy 	= Helpers::get_value( $settings, 'taxonomy', 'category' );
		$taxObject	= get_taxonomy( $taxonomy );
		$postType 	= Helpers::get_value($settings, 'postType', 'post');

		if( ! in_array( $postType, $taxObject->object_type ) ) {
			return $this->render_element_placeholder(
				[
					'title' => esc_html__( "Select correct taxonomy of '{$postType}' post type.", 'bricksultimate' ),
				]
			);
		}

		$terms 	= get_terms( $taxonomy, apply_filters( 'bu_ajax_search_terms_dropdown_args', $args ) );
		$depth 	= Helpers::get_value( $settings, 'depth', 0 );
		$cur_cat = 0;

		if( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
			$this->set_attribute("bu-ajax-search-terms", "class", ['bu-as-cat', 'search-by-category']);
			echo "<div {$this->render_attributes('bu-ajax-search-terms')}>";
			?>
			<input type="hidden" name="<?php echo $taxonomy; ?>" value="<?php echo $cur_cat; ?>" />
			<a href="#" rel="nofollow" data-val="<?php echo $cur_cat; ?>" class="trigger-terms-dd">
				<span>
					<?php echo Helpers::get_value( $settings,'optionText', esc_html__( 'Select category', 'bricksultimate' ) ); ?>
				</span>

				<?php 
					//* display arrow icon
					if( isset( $settings['arrowIcon'] ) ) {
						echo self::render_icon( $settings['arrowIcon'], ['bu-as-dd--icon'] );
					}
				?>
			</a>
			<div class="bu-as-cat-dropdown bu-as-cat-content<?php echo ( ! empty($settings['builderPreview']) && (bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ) ? ' bu-as-dd-opened' : ''); ?>">
				<ul class="bu-as-cat-list">
					<li style="display:none;">
						<a href="#" data-val="<?php echo $cur_cat; ?>"><?php echo Helpers::get_value( $settings,'optionText', esc_html__( 'Select category', 'bricksultimate' ) ); ?></a>
					</li>
				<?php 
					$args = array( 
						'hide_empty' 	=> ! empty( $settings['hide_empty'] ),
						'child_of' 		=> Helpers::get_value( $settings, 'child_of', 0),
						'depth' 		=> $depth,
						'taxonomy' 		=> $taxonomy,
						'orderby' 		=> Helpers::get_value( $settings, 'orderby', 'name'),
						'order' 		=> Helpers::get_value( $settings, 'order', 'ASC'),
						'title_li' 		=> false,
						'use_desc_for_title' => false,
						'walker' 		=> new BuAjaxSearchCategoryWalker(),
					);

					$include_ids = Helpers::get_value($settings, 'include_ids', false);
					if( $include_ids ) {
						$args['include'] = array_filter( array_map( 'trim', explode( ',', $include_ids ) ) );
					}

					$exclude_ids = Helpers::get_value($settings, 'exclude_ids', false);
					if( $exclude_ids ) {
						$args['exclude'] = array_filter( array_map( 'trim', explode( ',', $exclude_ids ) ) );
					}
					wp_list_categories( $args );
				?>
				</ul>
			</div>
			<?php
			echo "</div>";
		}
	}

	public function getSearchButton( $settings ) {
		$this->set_attribute("bu-ajax-search-button", "class", ['search-submit', 'search-button']);

		if( ! empty( $settings['buttonArrow'] ) ) {
			$this->set_attribute("bu-ajax-search-button", "class", ['has-arrow']);
		}

		if( ! empty( $settings['btnArialabel'] ) )
			$this->set_attribute("bu-ajax-search-button", "aria-label", esc_attr( $settings['btnArialabel'] ) );

		$formButton = "<button type=\"submit\" {$this->render_attributes("bu-ajax-search-button")}>";

		$formButton .= ! empty( $settings['searchIcon'] ) ? self::render_icon( $settings['searchIcon'], ['bu-as--icon bu-as-search-icon'] ) : '';

		$formButton .= ! empty( $settings['loadingIcon'] ) ? self::render_icon( $settings['loadingIcon'], ['bu-as--icon loading-icon'] ) : '';

		$formButton .= "</button>";

		echo $formButton;
	}
}