<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class DualColorHeading extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-dual-color-text';
	public $icon 			= 'ti-text';
	public $tag 			= 'h3';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Dual Color Text', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['separator'] = [
			'title'      => esc_html__( 'separator', 'bricks' ),
			'tab'        => 'content',
			'fullAccess' => true, // NOTE: Undocumented (show if user role has full_access capability)
		];

		$this->control_groups['link'] = [
			'title'      => esc_html__( 'link', 'bricks' ),
			'tab'        => 'content'
		];
	}

	public function set_controls() {
		$this->controls['tag'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Tag', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'h1' 	=> 'h1',
				'h2' 	=> 'h2',
				'h3' 	=> 'h3',
				'h4' 	=> 'h4',
				'h5' 	=> 'h5',
				'h6' 	=> 'h6',
				'div' 	=> 'div',
				'p' 	=> 'p',
			],
			'inline'    => true,
			'clearable' => false,
			'default'   => 'h3',
		];

		$this->controls['text_sep'] = [
			'tab' 		=> 'content',
			'type' 		=> 'separator',
			'label' 	=> esc_html__('First Text', 'bricksultimate')
		];

		$this->controls['text'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__('Text', 'bricksultimate'),
			'default' 		=> esc_html__('This is', 'bricksultimate'),
			'placeholder' 	=> esc_html__('This is', 'bricksultimate')
		];

		$this->controls['text_bg'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-dual-text',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['text_typography'] = [
			'tab' 		=> 'content',
			'type' 		=> 'typography',
			'label' 	=> esc_html__('Typography', 'bricks'),
			'css' 		=> [
				[
					'selector' => '.bu-dual-text',
					'property' => 'font'
				]
			]
		];

		$this->controls['text_margin'] = [
			'tab' 		=> 'content',
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.bu-dual-text',
				]
			],
		];

		$this->controls['text_padding'] = [
			'tab' 		=> 'content',
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.bu-dual-text',
				]
			],
		];

		$this->controls['text_sep_alt'] = [
			'tab' 		=> 'content',
			'type' 		=> 'separator',
			'label' 	=> esc_html__('Second Text', 'bricksultimate')
		];

		$this->controls['text_alt'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__('Text', 'bricksultimate'),
			'default' 		=> esc_html__('dual color heading', 'bricksultimate'),
			'placeholder' 	=> esc_html__('dual color heading', 'bricksultimate')
		];

		$this->controls['text_alt_bg'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-dual-text-alt',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['text_alt_typography'] = [
			'tab' 		=> 'content',
			'type' 		=> 'typography',
			'label' 	=> esc_html__('Typography', 'bricks'),
			'default' 	=> [
				'color' 	=> [
					'rgb' => '#ff5964'
				]
			],
			'css' 		=> [
				[
					'selector' => '.bu-dual-text-alt',
					'property' => 'font'
				]
			]
		];

		$this->controls['text_alt_margin'] = [
			'tab' 		=> 'content',
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.bu-dual-text-alt',
				]
			],
		];

		$this->controls['text_alt_padding'] = [
			'tab' 		=> 'content',
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.bu-dual-text-alt',
				]
			],
		];

		$this->controls['link'] = [
			'tab'   => 'content',
			'group' => 'link',
			'label' => esc_html__( 'Link to', 'bricks' ),
			'type'  => 'link',
		];

		// Group: Separator

		$this->controls['separator'] = [
			'tab'         => 'content',
			'group'       => 'separator',
			'label'       => esc_html__( 'Separator', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'right' => esc_html__( 'Right', 'bricks' ),
				'left'  => esc_html__( 'Left', 'bricks' ),
				'both'  => esc_html__( 'Both', 'bricks' ),
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'None', 'bricks' ),
		];

		$this->controls['separatorWidth'] = [
			'tab'   => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.separator',
				],
				[
					'property' => 'flex-grow',
					'selector' => '.separator',
					'value'    => 0,
				],
			],
		];

		$this->controls['separatorHeight'] = [
			'tab'   => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'border-top-width',
					'selector' => '.separator',
				],
				[
					'property' => 'height',
					'selector' => '.separator',
				],
			],
		];

		$this->controls['separatorSpacing'] = [
			'tab'         => 'content',
			'group'       => 'separator',
			'label'       => esc_html__( 'Spacing', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'small'       => false,
			'css'         => [
				[
					'property' => 'margin-right',
					'selector' => '.separator.left',
				],
				[
					'property' => 'margin-left',
					'selector' => '.separator.right',
				],
			],
			'placeholder' => 20,
		];

		$this->controls['separatorStyle'] = [
			'tab'     => 'content',
			'group'   => 'separator',
			'label'   => esc_html__( 'Style', 'bricks' ),
			'type'    => 'select',
			'options' => $this->control_options['borderStyle'],
			'css'     => [
				[
					'property' => 'border-top-style',
					'selector' => '.separator',
				],
			],
			'inline'  => true,
		];

		$this->controls['separatorAlignItems'] = [
			'tab'         => 'content',
			'group'       => 'separator',
			'label'       => esc_html__( 'Align', 'bricks' ),
			'type'        => 'align-items',
			'exclude'     => 'stretch',
			'css'         => [
				[
					'property'  => 'align-items',
					'selector'  => '&.has-separator',
					'important' => true,
				],
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'Center', 'bricks' ),
		];

		$this->controls['separatorColor'] = [
			'tab'   => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'border-top-color',
					'selector' => '.separator',
				],
			],
		];
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		if ( isset( $settings['separator'] ) ) {
			$this->set_attribute( '_root', 'class', 'brxe-heading' );
		}

		if ( isset( $settings['separator'] ) ) {
			$this->set_attribute( '_root', 'class', 'has-separator' );
		}

		$output = "<{$this->tag} {$this->render_attributes( '_root' )}>";

		// Separator
		if ( isset( $settings['separator'] ) && $settings['separator'] !== 'right' ) {
			$output .= '<span class="separator left"></span>';
		}

		if ( isset( $settings['link'] ) ) {
			$this->set_link_attributes( 'a', $settings['link'] );
			$output .= "<a {$this->render_attributes( 'a' )}>";
		}

		if ( ! empty( $settings['text'] ) || ! empty( $settings['text_alt'] ) ) {
			$text = ! empty( $settings['text'] ) ? '<span class="bu-dual-text">' . $settings['text'] . '</span>&nbsp;' : '';
			$text .= ! empty( $settings['text_alt'] ) ? '<span class="bu-dual-text-alt">' . $settings['text_alt'] . '</span>' : '';
			$output .= isset( $settings['separator'] ) ? '<span class="text-wrap">' . $text . '</span>' : $text;
		}

		if ( isset( $settings['link'] ) ) {
			$output .= '</a>';
		}

		// Separator
		if ( isset( $settings['separator'] ) && $settings['separator'] !== 'left' ) {
			$output .= '<span class="separator right"></span>';
		}

		$output .= "</{$this->tag}>";

		echo $output;
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-dual-color-text">
			<component
				:is="tag"
				:class="[
					'brxe-heading',
					settings.separator ? 'has-separator' : null
				]">
				<span v-if="settings.separator && settings.separator !== 'right'" class="separator left"></span>

				<a v-if="settings.link">
					<contenteditable
						tag="span"
						class="bu-dual-text"
						:name="name"
						controlKey="text"
						toolbar="style"
						:settings="settings"/>&nbsp;<contenteditable
						tag="span"
						class="bu-dual-text-alt"
						:name="name"
						controlKey="text_alt"
						toolbar="style"
						:settings="settings"/>
				</a>

				<contenteditable
					v-if="!settings.link"
					tag="span"
					class="bu-dual-text"
					:name="name"
					controlKey="text"
					toolbar="style"
					:settings="settings"/>&nbsp;<contenteditable
					v-if="!settings.link"
					tag="span"
					class="bu-dual-text-alt"
					:name="name"
					controlKey="text_alt"
					toolbar="style"
					:settings="settings"/>

				<span v-if="settings.separator && settings.separator !== 'left'" class="separator right"></span>
			</component>
		</script>
		<?php
	}
}