<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class TableGrid extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-table-grid';
	public $icon 			= 'ti-view-list';
	public $scripts 		= [ 'buTableGrid' ];
	public $tag 			= 'div';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Table', 'bricksultimate' ) . ' (' . esc_html__( 'Grid View', 'bricksultimate' ) . ')';
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['thead'] = [
			'title' 	=> esc_html__( 'Table Head', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['pagination'] = [
			'title' 	=> esc_html__( 'Pagination', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['search'] = [
			'title' 	=> esc_html__( 'Search Form', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['language'] = [
			'title' 	=> esc_html__( 'l10N', 'bricksultimate' ),
			'tab' 		=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {

		$this->controls['notFoundText'] = [
			'group' => 'language',
			'type' 	=> 'text',
			'label' => __('No records found text', 'bricksultimate'),
			'placeholder' => esc_html__("No matching records found", 'bricksultimate')
		];

		$this->controls['errorText'] = [
			'group' => 'language',
			'type' 	=> 'text',
			'label' => __('Error text', 'bricksultimate'),
			'placeholder' => esc_html__("An error happened while fetching the data", 'bricksultimate'),
		];

		$this->controls['table_raw_data'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Show raw table in the editor', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['bottomBtns'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Hide the bottom buttons', 'bricksultimate'),
			'info' => esc_html__('These buttons are for the builder editor only.', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['textWrap'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => __('Disable text wrap', 'bricksultimate'),
			'inline' => true,
		];

		//* Table head
		$this->controls['fixedHeader'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'checkbox',
			'label' => __('Fixed header', 'bricksultimate'),
			'description' => esc_html__('You should set height under the Style->Layout.', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['resize'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'checkbox',
			'label' => __('Resizable columns', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['sort'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'checkbox',
			'label' => __('Sortable columns', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['thHoverColor'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'color',
			'label' => __('Hover text color', 'bricksultimate'),
			'inline' => true,
			'css' 	=> [
				[
					'selector' => 'th.gridjs-th-sort:hover',
					'property' => 'color'
				]
			],
			'required' => ['sort', '=', true]
		];

		$this->controls['thHoverBG'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'color',
			'label' => __('Hover background color', 'bricksultimate'),
			'inline' => true,
			'css' 	=> [
				[
					'selector' => 'th.gridjs-th-sort:hover',
					'property' => 'background-color'
				]
			],
			'required' => ['sort', '=', true]
		];

		$this->controls['thFocusColor'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'color',
			'label' => __('Focus text color', 'bricksultimate'),
			'inline' => true,
			'css' 	=> [
				[
					'selector' => 'th.gridjs-th-sort:focus',
					'property' => 'color'
				]
			],
			'required' => ['sort', '=', true]
		];

		$this->controls['thFocusBG'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'color',
			'label' => __('Focus background color', 'bricksultimate'),
			'inline' => true,
			'css' 	=> [
				[
					'selector' => 'th.gridjs-th-sort:focus',
					'property' => 'background-color'
				]
			],
			'required' => ['sort', '=', true]
		];

		$this->controls['sortSep'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'separator',
		];

		$this->controls['thMgn'] = [
			'tab' 		=> 'content',
			'group' 	=> 'thead',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'margin',
					'selector' 	=> 'th.gridjs-th'
				]
			]
		];

		$this->controls['thPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'thead',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'padding',
					'selector' 	=> 'th.gridjs-th'
				]
			],
			'placeholder' => [
				'top' 		=> 14,
				'bottom' 	=> 14,
				'right' 	=> 24,
				'left' 		=> 24
			]
		];

		$this->controls['spSep'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'separator',
		];

		$this->controls['typographyTh'] = [
			'tab'   => 'content',
			'group' => 'thead',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => 'th.gridjs-th',
				],
			],
		];

		$this->controls['theadBG'] = [
			'tab' 	=> 'content',
			'group' => 'thead',
			'type' 	=> 'color',
			'label' => __('Background color', 'bricksultimate'),
			'inline' => true,
			'css' 	=> [
				[
					'selector' => 'th.gridjs-th',
					'property' => 'background-color'
				]
			]
		];

		$this->controls['borderTh'] = [
			'tab'   => 'content',
			'group' => 'thead',
			'label' => esc_html__( 'Border color', 'bricks' ),
			'type'  => 'color',
			'inline' => true,
			'css'   => [
				[
					'property' => 'border-color',
					'selector' => 'th.gridjs-th',
				],
			],
		];

		//* Pagination
		$this->controls['pagination'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'checkbox',
			'label' => __('Enable pagination', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['limit'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'number',
			'unitless' => true,
			'min' => 1,
			'max' => 20,
			'step' => 1,
			'label' => __('Rows per page', 'bricksultimate'),
			'inline' => true,
			'placeholder' => 10,
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['pnButtons'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'checkbox',
			'label' => __('Disable prev/next buttons', 'bricksultimate'),
			'inline' => true,
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['summary'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'checkbox',
			'label' => __('Disable summary text', 'bricksultimate'),
			'inline' => true,
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['summarySep'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'separator',
			'required' => [ [ 'summary', '!=', true], [ 'pagination', '=', true ] ]
		];

		$this->controls['showingText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('Showing text', 'bricksultimate'),
			'placeholder' => esc_html__('Showing'),
			'required' => [ [ 'summary', '!=', true], [ 'pagination', '=', true ] ]
		];

		$this->controls['resultsText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('Results text', 'bricksultimate'),
			'placeholder' => esc_html__('results'),
			'required' => [ [ 'summary', '!=', true], [ 'pagination', '=', true ] ]
		];

		$this->controls['toText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('To text', 'bricksultimate'),
			'placeholder' => esc_html__('to'),
			'required' => [ [ 'summary', '!=', true], [ 'pagination', '=', true ] ]
		];

		$this->controls['ofText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('Of text', 'bricksultimate'),
			'placeholder' => esc_html__('of'),
			'required' => [ [ 'summary', '!=', true], [ 'pagination', '=', true ] ]
		];

		$this->controls['styleFooterSep'] = [
			'tab'   => 'content',
			'group'	=> 'pagination',
			'type'  => 'separator',
			'label' => esc_html__( 'Style', 'bricksultimate' ),
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['footerMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'pagination',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'margin',
					'selector' 	=> '.gridjs-footer'
				]
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['footerPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'pagination',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'padding',
					'selector' 	=> '.gridjs-footer'
				]
			],
			'placeholder' => [
				'top' 		=> 14,
				'bottom' 	=> 14,
				'right' 	=> 24,
				'left' 		=> 24
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['paginationBG'] = [
			'tab'    => 'content',
			'group'  => 'pagination',
			'type'   => 'color',
			'label'  => esc_html__( 'Background', 'bricks' ),
			'css'    => [
				[
					'property' => 'background-color',
					'selector' => '.gridjs-footer',
				],
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['paginationTg'] = [
			'tab'    => 'content',
			'group'  => 'pagination',
			'type'   => 'typography',
			'label'  => esc_html__( 'Typography', 'bricks' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => '.gridjs-pagination',
				],
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['paginationBRD'] = [
			'tab'    => 'content',
			'group'  => 'pagination',
			'type'   => 'border',
			'label'  => esc_html__( 'Border', 'bricks' ),
			'css'    => [
				[
					'property' => 'border',
					'selector' => '.gridjs-footer',
				],
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['paginationBS'] = [
			'tab'    => 'content',
			'group'  => 'pagination',
			'type'   => 'box-shadow',
			'label'  => esc_html__( 'Box shadow', 'bricks' ),
			'css'    => [
				[
					'property' => 'box-shadow',
					'selector' => '.gridjs-footer',
				],
			],
			'required' => [ 'pagination', '=', true ]
		];

		$this->controls['pnButtonsSep'] = [
			'tab'   => 'content',
			'group'	=> 'pagination',
			'type'  => 'separator',
			'label' => esc_html__( 'Buttons', 'bricks' ),
			'required' => ['pagination', '=', true],
		];

		$this->controls['buttonsCount'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'number',
			'unitless' => true,
			'min' => 1,
			'max' => 20,
			'step' => 1,
			'label' => __('Number of buttons to display', 'bricksultimate'),
			'inline' => true,
			'placeholder' => 2,
			'required' => ['pagination', '=', true],
		];

		$this->controls['prevText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('Previous text', 'bricksultimate'),
			'placeholder' => esc_html__('Previous'),
			'required' => [['pagination', '=', true], [ 'pnButtons', '!=', true]],
		];

		$this->controls['nextText'] = [
			'tab' 	=> 'content',
			'group' => 'pagination',
			'type' 	=> 'text',
			'label' => __('Next text', 'bricksultimate'),
			'placeholder' => esc_html__('Next'),
			'required' => [['pagination', '=', true], [ 'pnButtons', '!=', true]],
		];

		$this->controls['buttonsBG'] = [
			'tab' => 'content',
			'group'	=> 'pagination',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type' => 'color',
			'small' => true,
			'inline' => true,
			'css' => [
				[
					'property' => 'background-color',
					'selector' => '.gridjs-pagination .gridjs-pages button',
				]
			],
			'required' => ['pagination', '=', true],
		];

		$this->controls['buttonsColor'] = [
			'tab' => 'content',
			'group'	=> 'pagination',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type' => 'color',
			'small' => true,
			'inline' => true,
			'css' => [
				[
					'property' => 'color',
					'selector' => '.gridjs-pagination .gridjs-pages button',
				]
			],
			'required' => ['pagination', '=', true],
		];

		$this->controls['buttonsCurBG'] = [
			'tab' => 'content',
			'group'	=> 'pagination',
			'label' => esc_html__( 'Current page background color', 'bricks' ),
			'type' => 'color',
			'small' => true,
			'inline' => true,
			'css' => [
				[
					'property' => 'background-color',
					'selector' => '.gridjs-pagination .gridjs-pages button.gridjs-currentPage',
				]
			],
			'required' => ['pagination', '=', true],
		];

		$this->controls['buttonsCurColor'] = [
			'tab' => 'content',
			'group'	=> 'pagination',
			'label' => esc_html__( 'Current page color', 'bricks' ),
			'type' => 'color',
			'small' => true,
			'inline' => true,
			'css' => [
				[
					'property' => 'color',
					'selector' => '.gridjs-pagination .gridjs-pages button.gridjs-currentPage',
				]
			],
			'required' => ['pagination', '=', true],
		];

		$this->controls['buttonsPadding'] = [
			'tab' => 'content',
			'group'	=> 'pagination',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'spacing',
			'css' => [
				[
					'property' => 'padding',
					'selector' => '.gridjs-pagination .gridjs-pages button',
				]
			],
			'placeholder' => [
				'top' => '5px',
				'right' => '14px',
				'bottom' => '5px',
				'left' => '14px',
			],
			'required' => ['pagination', '=', true],
		];

		//* Search
		$this->controls['search'] = [
			'tab' 	=> 'content',
			'group' => 'search',
			'type' 	=> 'checkbox',
			'label' => __('Enable search form', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['searchWMrg'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type' => 'spacing',
			'css' => [
				[
					'property' => 'margin',
					'selector' => '.gridjs-head',
				]
			]
		];

		$this->controls['searchWPad'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'spacing',
			'css' => [
				[
					'property' => 'padding',
					'selector' => '.gridjs-head',
				]
			]
		];

		$this->controls['searchWBg'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Wrapper background color', 'bricks' ),
			'type' => 'color',
			'inline' => true,
			'css' => [
				[
					'property' => 'background-color',
					'selector' => '.gridjs-head',
				],
			]
		];

		$this->controls['searchInpSep'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Input field', 'bricks' ),
			'type' => 'separator'
		];

		$this->controls['searchText'] = [
			'tab' => 'content',
			'group'	=> 'search',
			'label' => esc_html__( 'Placeholder text', 'bricks' ),
			'type' => 'text',
			'placeholder' => 'Type a keyword...',
		];

		$this->controls['searchInpPad'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'spacing',
			'css' => [
				[
					'property' => 'padding',
					'selector' => '.gridjs-search-input',
				]
			]
		];

		$this->controls['searchInpW'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type' => 'number',
			'min' => 0,
			'max' => 10000,
			'step' => '1',
			'units' => true,
			'inline' => true,
			'css' => [
				[
					'property' => 'width',
					'selector' => 'input.gridjs-input',
				],
				[
					'property' => 'width',
					'selector' => '.gridjs-search',
				],
			]
		];

		$this->controls['searchPos'] = [
			'tab' => 'content',
			'group' => 'search',
			'type' => 'select',
			'label' => esc_html__( 'Float', 'bricks' ),
			'options' => [
				'left' => esc_html__( 'Left', 'bricks' ),
				'right' => esc_html__( 'Right', 'bricks' ),
				'none' => esc_html__( 'None', 'bricks' )
			],
			'css' => [
				[
					'property' => 'float',
					'selector' => '.gridjs-search',
				],
			],
			'placeholder' => esc_html__( 'Left', 'bricks' ),
			'inline'      => true,
		];

		$this->controls['searchBg'] = [
			'tab' => 'content',
			'group' => 'search',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type' => 'color',
			'inline' => true,
			'css' => [
				[
					'property' => 'background-color',
					'selector' => 'input.gridjs-input',
				]
			]
		];

		$this->controls['searchTg'] = [
			'tab'    => 'content',
			'group'  => 'search',
			'type'   => 'typography',
			'label'  => esc_html__( 'Typography', 'bricks' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => 'input.gridjs-input'
				],
			]
		];

		$this->controls['searchPClr'] = [
			'tab'    => 'content',
			'group'  => 'search',
			'type'   => 'color',
			'label'  => esc_html__( 'Placeholder text color', 'bricks' ),
			'css'    => [
				[
					'property' => 'color',
					'selector' => 'input.gridjs-input::placeholder'
				],
			]
		];

		$this->controls['searchBorder'] = [
			'tab'   => 'content',
			'group' => 'search',
			'type'  => 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css'   => [
				[
					'property' => 'border',
					'selector' => 'input.gridjs-input'
				],
			]
		];

		$this->controls['_typography']['css'][0]['selector'] = '.gridjs-table';
		$this->controls['_background']['css'][0]['selector'] = '.gridjs-wrapper';
		$this->controls['_border']['css'][0]['selector']     = '.gridjs-wrapper';
		$this->controls['_boxShadow']['css'][0]['selector']  = '.gridjs-wrapper';
		$this->controls['_padding']['css'][0]['selector']	 = '.gridjs-wrapper';
		//$this->controls['_margin']['css'][0]['selector']	 = '.gridjs-wrapper';
		$this->controls['_width']['css'][0]['selector']  	 = '.gridjs-wrapper';
		$this->controls['_minWidth']['css'][0]['selector'] 	 = '.gridjs-wrapper';
		$this->controls['_maxWidth']['css'][0]['selector'] 	 = '.gridjs-wrapper';
		$this->controls['_height']['css'][0]['selector'] 	 = '.gridjs-wrapper';

		//* Default settings
		$this->controls['_boxShadow']['default']= [
			'values' => [
				'offsetX' => 0,
				'offsetY' => 0,
				'blur' => 0
			]
		];

		$this->controls['_border']['default']= [
			'radius' => [
				'top' => 0,
				'right' => 0,
				'bottom' => 0,
				'left' => 0
			],
			'width' => [
				'top' => 1,
				'right' => 1,
				'bottom' => 1,
				'left' => 1
			],
			'style' => 'solid',
			'color' => [
				'hex' => '#e5e7eb'
			]
		];
	}

	public function get_nestable_children() {
		return [
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Head', 'bricks' ),
				'deletable' => false,
				'cloneable' => false,
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tr'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'th', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'th',
							'_hidden' => [
								'_cssClasses' => 'gridjs-th'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'First Name', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'th', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'th',
							'_hidden' => [
								'_cssClasses' => 'gridjs-th'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Last Name', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'th', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'th',
							'_hidden' => [
								'_cssClasses' => 'gridjs-th'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Email', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
				]
			],
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Row', 'bricks' ),
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tr'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Jhon', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Doe', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'example@gmail.com', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
				]
			],
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Row', 'bricks' ),
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tr'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Paul', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Smith', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
							'_hidden' => [
								'_cssClasses' => 'gridjs-td'
							]
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'example@hotmail.com', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
				]
			],
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		//if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ) {
			wp_enqueue_style( 'bu-table-grid', Helpers::get_asset_url('css') . 'bu.tablegrid.min.css', [], filemtime(Helpers::get_asset_path('css') . 'bu.tablegrid.min.css'), 'all' );
		//}
		
		wp_enqueue_script( 'bu-table-grid', Helpers::get_asset_url('js') . 'bu.table.min.js', [], filemtime(Helpers::get_asset_path('js') . 'bu.table.min.js'), true );
	}

	public function render() {
		$settings = $this->settings;
		$config = [
			'sort' 			=> isset( $settings['sort'] ) ? true : false,
			'resizable' 	=> isset( $settings['resize'] ) ? true : false,
			'search' 		=> isset( $settings['search'] ) ? true : false,
			'fixedHeader' 	=> ! empty( $settings['fixedHeader'] ) ? true : false,
			'pagination' 	=> isset( $settings['pagination'] ) ? true : false,
			'summary' 		=> isset( $settings['summary'] ) ? false : true,
			'pnButtons' 	=> isset( $settings['pnButtons'] ) ? false : true,
			'limit' 		=> isset( $settings['limit'] ) ? $settings['limit'] : 10,
			'buttonsCount' 	=> isset( $settings['buttonsCount'] ) ? $settings['buttonsCount'] : 2,
			'height' 		=> isset( $settings['_height'] ) ? $settings['_height'] : '400px',
			'searchText' 	=> isset( $settings['searchText'] ) ? $settings['searchText'] : 'Type a keyword...',
			'prevText' 		=> isset( $settings['prevText'] ) ? $settings['prevText'] : 'Previous',
			'nextText' 		=> isset( $settings['nextText'] ) ? $settings['nextText'] : 'Next',
			'showingText' 	=> isset( $settings['showingText'] ) ? $settings['showingText'] : 'Showing',
			'resultsText' 	=> isset( $settings['resultsText'] ) ? $settings['resultsText'] : 'results',
			'notFoundText' 	=> isset( $settings['notFoundText'] ) ? $settings['notFoundText'] : "No matching records found",
			'errorText'		=> isset( $settings['errorText'] ) ? $settings['errorText'] : "An error happened while fetching the data",
			'toText' 		=> isset( $settings['toText'] ) ? $settings['toText'] : 'to',
			'ofText' 		=> isset( $settings['ofText'] ) ? $settings['ofText'] : 'of',
			'textWrap' 		=> isset( $settings['textWrap'] ) ? 'nowrap' : 'normal'
		];

		$this->set_attribute( '_root', 'data-bu-tblg-config', wp_json_encode( $config, JSON_UNESCAPED_UNICODE ) );
		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
			echo "<table class=\"bu-hidden-table bu-raw-table\">";
			echo \Bricks\Frontend::render_children( $this );
			echo "</table>";
			echo "<div class=\"bu-table-grid-wrapper\"></div>";
		echo "</{$this->tag}>";
	}

	public static function render_builder() {
		?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-table-grid">
			<component 
				:is="tag" 
				:data-bu-tblg-config="JSON.stringify({
					sort: settings.hasOwnProperty('sort') ? true : false,
					resizable: false,
					fixedHeader: settings.hasOwnProperty('fixedHeader') ? true : false,
					search: settings.hasOwnProperty('search') ? true : false,
					height: settings.hasOwnProperty('_height') ? settings._height : '400px',
					pagination: settings.hasOwnProperty('pagination') ? true : false,
					limit: settings.hasOwnProperty('limit') ? settings.limit : 10,
					summary: settings.hasOwnProperty('summary') ? false : true,
					buttonsCount: settings.hasOwnProperty('buttonsCount') ? settings.buttonsCount : 2,
					pnButtons: settings.hasOwnProperty('pnButtons') ? false : true,
					textWrap: settings.hasOwnProperty('textWrap') ? 'nowrap' : 'normal',
					searchText: settings.hasOwnProperty('searchText') ? settings.searchText : 'Type a keyword...',
					prevText: settings.hasOwnProperty('prevText') ? settings.prevText : 'Previous',
					nextText: settings.hasOwnProperty('nextText') ? settings.nextText : 'Next',
					showingText: settings.hasOwnProperty('showingText') ? settings.showingText : 'Showing',
					resultsText: settings.hasOwnProperty('resultsText') ? settings.resultsText : 'results',
					notFoundText: settings.hasOwnProperty('notFoundText') ? settings.notFoundText : 'No matching records found',
					errorText: settings.hasOwnProperty('errorText') ? settings.errorText : 'An error happened while fetching the data',
					toText: settings.hasOwnProperty('toText') ? settings.toText : 'to',
					ofText: settings.hasOwnProperty('ofText') ? settings.ofText : 'of'
				})"
			>
				<table class="gridjs-table" :class="[{'bu-hidden-table':!settings.table_raw_data},'bu-raw-table']">
					<bricks-element-children :element="element" />
				</table>
				<div class="bu-table-grid-wrapper"></div>
				<div :class="[{'bu-hidden-table':settings.bottomBtns}]" style="text-align: center; width: 100%; z-index:98747949; poisition: relative; pointer-events: auto">
					<span class="bu-tb-apply-preview" role="button" style="background: #fff;border: 1px solid #787878; display: inline-block; margin: 10px 0;padding: 10px 20px;pointer-events: auto">Apply Changes</span>&nbsp;&nbsp;&nbsp;&nbsp;
					<span data-action="start" class="bu-tb-apply-autoup" role="button" style="background: #fff;border: 1px solid #787878; display: inline-block; margin: 10px 0;padding: 10px 20px;pointer-events: auto">Start Autoupdate</span>
				</div>
			</component>
		</script>
	<?php 
	}
}