<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooAddToCartIcon extends \Bricks\Element_Div {
	public $category 		= 'ultimate';
	public $name 			= 'bu-atci';
	public $icon 			= 'ti-shopping-cart';
	public $scripts 		= ['buATCTooltip'];
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Add To Cart Icon', 'bricksultimate' );
	}
	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['tooltip'] = [
			'title' 	=> esc_html__( 'Tooltip', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['added'] = [
			'title' 	=> esc_html__( 'Added', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['viewcart'] = [
			'title' 	=> esc_html__( 'View Cart', 'bricksultimate' ),
			'tab' 		=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		parent::set_controls();

		$this->controls['disableTooltip'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Disable tooltip', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'reset' 	=> true
		];

		$this->controls['ttText'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Text', 'bricksultimate'),
			'type' 		=> 'text',
			'inline' 	=> true,
			'placeholder' => 'add to cart',
			'required' 	=> ['disableTooltip', '!=', true]
		];

		$this->controls['ttBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Background color', 'bricksultimate'),
			'type' 		=> 'color',
			'inline' 	=> true,
			'css' 	=> [
				[
					'property' => 'background-color', 
					'selector' => '.tippy-box'
				]
			],
			'required' 	=> ['disableTooltip', '!=', true]
		];

		$this->controls['ttAcolor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Arrow color', 'bricksultimate'),
			'type' 		=> 'color',
			'inline' 	=> true,
			'css' 	=> [
				[ 
					'property' => 'color', 
					'selector' => '.tippy-arrow'
				]
			],
			'required' 	=> ['disableTooltip', '!=', true]
		];

		$this->controls['ttTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Typography', 'bricksultimate'),
			'type' 		=> 'typography',
			'inline' 	=> true,
			'css' 	=> [
				[
					'property' => 'font', 
					'selector' => '.tippy-content'
				]
			],
			'required' 	=> ['disableTooltip', '!=', true]
		];

		$this->controls['ttPlacement'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Position', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'top' 			=> __( 'Top' ), 
				'top-start' 	=> __( 'Top Start' ), 
				'top-end' 		=> __( 'Top End' ),
				'right' 		=> __( 'Right' ), 
				'right-start' 	=> __( 'Right Start' ), 
				'right-end' 	=> __( 'Right End' ),
				'bottom' 		=> __( 'Bottom' ), 
				'bottom-start' 	=> __( 'Bottom Start' ), 
				'bottom-end' 	=> __( 'Bottom End' ),
				'left' 			=> __( 'Left' ), 
				'left-start' 	=> __( 'Left Start' ), 
				'left-end' 		=> __( 'Left End' ), 
				'auto' 			=> __( 'Auto' ), 
				'auto-start' 	=> __( 'Auto Start' ), 
				'auto-end' 		=> __( 'Auto End' ),
			],
			'inline' 		=> true,
			'placeholder' 	=> 'auto',
			'required' 	=> ['disableTooltip', '!=', true]
		];

		$this->controls['ttAnimation'] = [
			'tab' 		=> 'content',
			'group' 	=> 'tooltip',
			'label' 	=> esc_html__('Animation', 'bricksultimate'),
			'type' 		=> 'select',
			'options' 	=> [
				'fade' 			=> __( 'Fade' ), 
				'shift-away' 	=> __( 'Shift Away' ), 
				'shift-toward' 	=> __( 'Shift Toward' ), 
				'perspective' 	=> __( 'Perspective' )
			],
			'inline' 		=> true,
			'placeholder' 	=> 'Fade',
			'required' 	=> ['disableTooltip', '!=', true]
		];

		//* View cart button
		$this->controls['showViewCart'] = [
			'tab' 		=> 'content',
			'group' 	=> 'viewcart',
			'label' 	=> esc_html__('Show view cart link', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.added_to_cart',
					'value' 	=> 'flex'
				]
			]
		];

		$this->controls['vcTG'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.added_to_cart'
				],
			],
		];

		$this->controls['vcHColor'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Hover color', 'bricks' ),
			'type'     => 'color',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.added_to_cart:hover'
				],
			],
		];

		$this->controls['vcBG'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Background color', 'bricks' ),
			'type'     => 'color',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.added_to_cart'
				],
			],
		];

		$this->controls['vcHBG'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Hover background color', 'bricks' ),
			'type'     => 'color',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.added_to_cart:hover'
				],
			],
		];

		$this->controls['vcBorder'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.added_to_cart'
				],
			],
		];

		$this->controls['vcShadow'] = [
			'tab'      => 'content',
			'group'    => 'viewcart',
			'label'    => esc_html__( 'Box shadow', 'bricks' ),
			'type'     => 'box-shadow',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'box-shadow',
					'selector' => '.added_to_cart'
				],
			],
		];

		$this->controls['vcWidth'] = [
			'tab'   => 'style',
			'group' => 'viewcart',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.added_to_cart',
				],
			],
			'required' => [ 'showViewCart', '=', true ],
		];

		$this->controls['vcHeight'] = [
			'tab'   => 'style',
			'group' => 'viewcart',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => '.added_to_cart',
				],
			],
			'required' => [ 'showViewCart', '=', true ],
		];

		$this->controls['vcMargin'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Margin', 'bricks' ),
			'type'     => 'dimensions',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'margin',
					'selector' => '.added_to_cart'
				],
			],
		];

		$this->controls['vcPad'] = [
			'tab'      => 'content',
			'group' 	=> 'viewcart',
			'label'    => esc_html__( 'Padding', 'bricks' ),
			'type'     => 'dimensions',
			'required' => [ 'showViewCart', '=', true ],
			'css'      => [
				[
					'property' => 'padding',
					'selector' => '.added_to_cart'
				],
			],
		];

		//* Added icon
		$this->controls['addedState'] = [
			'tab' 		=> 'content',
			'group' 	=> 'added',
			'label' 	=> esc_html__('Enable tick icon', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'reset' 	=> true
		];

		$this->controls['addedPreview'] = [
			'tab' 		=> 'content',
			'group' 	=> 'added',
			'label' 	=> esc_html__('Show preview on builder', 'bricksultimate'),
			'info' 		=> esc_html__('Click on Reload canvas icon to apply the changes', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'required'  => [ 'addedState', '=', true ],
		];

		$this->controls['showAddedIcon'] = [
			'tab' 		=> 'content',
			'group' 	=> 'added',
			'label' 	=> esc_html__('Show it on page load?', 'bricksultimate'),
			'info' 		=> esc_html__('If product in the cart, icon will show on page load', 'bricksultimate'),
			'description' => esc_html__('You will add the {post_class} dynamic tag to the loop builder wrapper.', 'bricksultimate'),
			'type' 		=> 'checkbox',
			'inline' 	=> true,
			'required'  => [ 'addedState', '=', true ],
		];

		$this->controls['addIcon'] = [
			'tab' 		=> 'content',
			'group' 	=> 'added',
			'label' 	=> esc_html__('Icon', 'bricksultimate'),
			'type' 		=> 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-check',
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconColor'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'required' => [ 'addedState', '=', true ],
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-added-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-added-icon'
				],
			],
		];

		$this->controls['iconSize'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Size', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ 'addedState', '=', true ],
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.bu-added-icon'
				],
			],
		];

		$this->controls['iconBg'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Background color', 'bricks' ),
			'type'     => 'color',
			'required' => [ 'addedState', '=', true ],
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.bu-added-icon'
				],
			],
		];

		$this->controls['iconBorder'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'required' => [ 'addedState', '=', true ],
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.bu-added-icon'
				],
			],
		];

		$this->controls['iconShadow'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Box shadow', 'bricks' ),
			'type'     => 'box-shadow',
			'required' => [ 'addedState', '=', true ],
			'css'      => [
				[
					'property' => 'box-shadow',
					'selector' => '.bu-added-icon'
				],
			],
		];

		$this->controls['iconPosSep'] = [
			'tab'   => 'style',
			'group' => 'added',
			'type'  => 'separator',
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconPosition'] = [
			'tab'     => 'style',
			'group'   => 'added',
			'label'   => esc_html__( 'Position', 'bricks' ),
			'type'    => 'select',
			'options' => \Bricks\Setup::$control_options['position'],
			'default' => 'absolute',
			'css'     => [
				[
					'property' => 'position',
					'selector' => '.bu-added-icon',
				],
			],
			'inline'  => true,
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconTop'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconRight'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconBottom'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconLeft'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconzIndex'] = [
			'tab'         => 'style',
			'group'       => 'added',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => '.bu-added-icon',
				],
			],
			'min'         => -999,
			'placeholder' => 0,
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconSpaceSep'] = [
			'tab'   => 'style',
			'group' => 'added',
			'type'  => 'separator',
		];

		$this->controls['iconWidth'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconHeight'] = [
			'tab'   => 'style',
			'group' => 'added',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => '.bu-added-icon',
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['iconPad'] = [
			'tab'      => 'content',
			'group' 	=> 'added',
			'label'    => esc_html__( 'Padding', 'bricks' ),
			'type'     => 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => '.bu-added-icon'
				],
			],
			'required' => [ 'addedState', '=', true ],
		];

		$this->controls['_padding']['default'] = [
			'top' 		=> 10,
			'right' 	=> 10,
			'bottom' 	=> 10,
			'left' 		=> 10,
		];

		$this->controls['_display']['default'] = 'flex';
		$this->controls['_alignItems']['default'] = 'center';
		$this->controls['_justifyContent']['default'] = 'center';
		$this->controls['_width']['default'] = 38;
		$this->controls['_height']['default'] = 38;
		$this->controls['_position']['default'] = 'absolute';
		$this->controls['_top']['default'] = 15;
		$this->controls['_right']['default'] = 15;

		$this->controls['_background']['default'] = [
			'color' => [
				'hex' => '#ffffff'
			]
		];
	}

	public function get_nestable_children() {
		return [
			[
				'name'     	=> 'icon',
				'label' 	=> esc_html__('Icon of Add to cart', 'bricksultimate'),
				//'deletable' => false,
				'settings' 	=> $this->getAddToCartSettings()
			],

			[
				'name' 		=> 'icon',
				'label' 	=> esc_html__('Icon of Select options', 'bricksultimate'),
				//'deletable' => false,
				'settings' 	=> $this->getSelectOptionsSettings()
			],

			[
				'name' 		=> 'icon',
				'label' 	=> esc_html__('Spinner icon', 'bricksultimate'),
				'deletable' => false,
				'settings' 	=> $this->getSpinnerSettings()
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		if( ! isset($this->settings['disableTooltip']) ) {
			wp_enqueue_style( 'bu-tooltip' );
			wp_enqueue_script( 'bu-popper' );
			wp_enqueue_script( 'bu-tippy' );
		}
		
		wp_enqueue_style( 'bu-atci', Helpers::get_asset_url('css') . 'buatci.min.css', [], filemtime(Helpers::get_asset_path('css') . 'buatci.min.css'), 'all' );
		
		wp_enqueue_script( 'bu-atci', Helpers::get_asset_url('js') . 'buatci.min.js', ['wc-add-to-cart'], filemtime(Helpers::get_asset_path('js') . 'buatci.min.js'), true );
	}

	// Render element HTML
	public function render() {
		global $product;

		if( ! is_a( $product, 'WC_Product' ) )
			$product = wc_get_product( $this->post_id );

		$product_id = get_post_meta( $this->post_id, '_buob_offer_product', true );
		if( empty( $product ) && $product_id ) {
			$product = wc_get_product( $product_id );
		}

		if( $product == false && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if ( empty( $product ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'For better preview select content to show.', 'bricks' ),
					'description' => esc_html__( 'Go to: Settings > Template Settings > Populate Content', 'bricks' ),
				]
			);
		}

		$settings = $this->settings;

		$this->set_attribute('_root', 'class', [ 'bu-prd-type-' . $product->get_type() ]);
		if( ! isset( $settings['disableTooltip'] ) && $product->is_in_stock()) {
			$tooltipContent = Helpers::get_value($settings, 'ttText', 'add to cart');
			$data = [
				'content' => wp_kses_post( $tooltipContent ),
				'animation' => Helpers::get_value($settings, 'ttAnimation', 'fade'),
				'placement' => Helpers::get_value($settings, 'ttPlacement', 'auto')
			];

			$this->set_attribute('_root', 'data-atci-tooltip', wp_json_encode( $data ));
		}

		if( ! $product->is_in_stock() && $product->get_type() == 'simple' )
			$this->set_attribute('_root', 'data-out-of-stock', 'yes');

		if( ! empty( $settings['showAddedIcon'] ) )
			$this->set_attribute('_root', 'class', ['show-added-icon']);

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
		echo \Bricks\Frontend::render_children( $this ) . ( get_option('bultimate_client') ?? '' );

		$tickIconClass = ['bu-added-icon'];

		if( ! empty( $settings['addedPreview'] ) && ( bricks_is_builder() || Helpers::isBricksBuilderActive() ) ) {
			$tickIconClass[] = 'bu-atc-tick-icon';
		}

		$icon = ! empty( $settings['addIcon'] ) ? self::render_icon( $settings['addIcon'], $tickIconClass ) : '';
		if( $icon && ! empty($settings['addedState'])) {
			echo $icon;
		}

		echo "</{$this->tag}>";
	}

	public function getAddToCartSettings() {
		return [
			'icon'     => [
				'icon'    => 'ti-shopping-cart',
				'library' => 'themify',
			],
			'iconSize' => '18px',
			'iconColor' => '#000000',
			'link' => [
				'type' 				=> 'meta',
				'useDynamicData' 	=> "{bu_add_to_cart_url}",
				'rel' 				=> 'nofollow'
			],
			'_hidden' => [
				'_cssClasses' => 'bu-add-to-cart'
			],
			'_attributes' => [
				[
					'id' => \Bricks\Helpers::generate_random_id( false ), 
					'name' => 'data-product_id', 
					'value' => '{post_id}' 
				],
				[
					'id' => \Bricks\Helpers::generate_random_id( false ), 
					'name' => 'data-quantity', 
					'value' => 1 
				],
				[
					'id' => \Bricks\Helpers::generate_random_id( false ), 
					'name' => 'aria-label', 
					'value' => 'Add "{post_title}" to your cart' 
				],
				[
					'id' => \Bricks\Helpers::generate_random_id( false ), 
					'name' => 'data-product_sku', 
					'value' => '{woo_product_sku:value}' 
				]
			],
		];
	}

	public function getSelectOptionsSettings() {
		return [
			'icon'     => [
				'icon'    => 'ti-info',
				'library' => 'themify',
			],
			'iconSize' => '18px',
			'iconColor' => '#000000',
			'link' => [
				'type' 				=> 'meta',
				'useDynamicData' 	=> "{bu_add_to_cart_url}",
				'rel' 				=> 'nofollow',
			],
			'_hidden' => [
				'_cssClasses' => 'bu-select-options'
			],
		];
	}

	public function getSpinnerSettings() {
		return [
			'icon'     => [
				'icon'    => 'ti-reload',
				'library' => 'themify',
			],
			'iconSize' => '14px',
			'iconColor' => '#000000',
			'_hidden' => [
				'_cssClasses' => 'bu-ajax-spinner'
			],
		];
	}

	public static function render_builder() {?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-atci">
			<component :is="'div'">
				<bricks-element-children :element="element" />
			</component>
		</script>
		<?php
	}
}