<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooCartQuantity extends \Bricks\Element {
	public $category 	= 'cart';
	public $name 		= 'bu-cart-item-qty';
	public $icon 		= 'ti-quote-left';
	public $called 		= false;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Item Quantity', 'bricksultimate' );
	}

	/**
	 * Adds control groups
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function set_control_groups() {
		$this->control_groups['qty'] = [
			'title' => esc_html__( 'Quantity', 'bricks' ),
			'tab'   => 'content',
			'required' => ['type', '=', 'button']
		];
	}

	// Set builder control groups
	public function set_controls() {
		$this->controls['type'] = [
			'tab' 		=> 'content',
			'type'   	=> 'select',
			'label'		=> esc_html__('Type'),
			'options' 	=> [
				'plain' 	=> esc_html__('Plain text', 'bricksultimate'),
				'button' 	=> esc_html__('Button', 'bricks')
			],
			'default'   => 'plain'
		];

		$this->controls['disableCartUpdate'] = [
			'tab' 		=> 'content',
			'type'   	=> 'checkbox',
			'label'		=> esc_html__('Disable autoupdate - Cart Page', 'bricksultimate'),
			'inline'   	=> true,
			'reset' 	=> true
		];

		$this->controls['tag'] = [
			'tab' 		=> 'content',
			'type'   	=> 'select',
			'label'		=> esc_html__('HTML Tag'),
			'options' 	=> [
				'div' 	=> 'div',
				'span' 	=> 'span',
				'p' 	=> 'p',
			],
			'lowercase'   => true,
			'inline'      => true,
			'placeholder' => $this->tag ? $this->tag : 'div',
			'fullAccess'  => true,
		];

		$this->controls['prefix'] = [
			'tab'   => 'content',
			'type'  => 'text',
			'label' => esc_html__( 'Prefix', 'bricks' )
		];

		$this->controls['suffix'] = [
			'tab'    => 'content',
			'type'   => 'text',
			'label'  => esc_html__( 'Suffix', 'bricks' )
		];

		$this->controls['qtyTg'] = [
			'tab'   => 'content',
			'type'  => 'typography',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> ''
				]
			]
		];

		$this->controls['prefixTg'] = [
			'tab'   => 'content',
			'type'  => 'typography',
			'label' => esc_html__( 'Prefix Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.prefix-text'
				]
			]
		];

		$this->controls['suffixTg'] = [
			'tab'   => 'content',
			'type'  => 'typography',
			'label' => esc_html__( 'Suffix Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.suffix-text'
				]
			]
		];

		$this->controls['separator'] = [
			'tab'   => 'content',
			'type'  => 'separator',
			'label' => esc_html__( 'Display', 'bricks' ),
		];

		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display'
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'default' 		=> 'nowrap',
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['direction'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      		=> 'content',
			'label'    		=> esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  		=> [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     		=> 'justify-content',
			'css'      		=> [
				[
					'property' => 'justify-content',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      		=> 'content',
			'label'    		=> esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip' 		=> [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		//* Quantity
		$selector = '.quantity';

		$this->controls['qtyWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '75px',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['qtyHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$this->controls['wraprBg'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Background', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$this->controls['wrapBorder'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Border', 'bricksultimate' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$this->controls['pmBtnSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( '+/- Buttons', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['pmBtnWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .action',
				]
			],
			'placeholder' => '40px'
		];

		$this->controls['pmBtnBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnSize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'unit' 	=> 'px',
			'placeholder' => '13px', 
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['pmBtnColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'color'
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'fill'
				]
			]
		];

		$this->controls['pmBtnBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['pmBtnHBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnHColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnHBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['inpSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Quantity field', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['inpWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '25px'
		];

		$this->controls['inpBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['qtySize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Font Size', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'font-size',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '10px'
		];

		$this->controls['inpColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['inpFocusBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['inpFocusColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'color',
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		$type = Helpers::get_value( $this->settings, 'type', 'plain' );
		if( $type == "button" ) {
			/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
				wp_enqueue_style( 
					'bu-item-qty', 
					Helpers::get_asset_url('css') . 'buitemqty.min.css', 
					[], 
					filemtime(Helpers::get_asset_path('css') . 'buitemqty.min.css' )
				);
			}*/

			wp_enqueue_script( 
				'bu-item-qty', 
				Helpers::get_asset_url('js') . 'buitemqty.min.js', 
				['wc-cart-fragments'], 
				filemtime(Helpers::get_asset_path('js') . 'buitemqty.min.js' ),
				true
			);
		}
	}

	// Render element HTML
	public function render() {

		if( is_null( WC()->cart ) || WC()->cart->is_empty() )
			return;

		$product_id = $this->post_id;
		$settings = $this->settings;

		$type = Helpers::get_value( $settings, 'type', 'plain' );
		$prefix = Helpers::get_value( $settings, 'prefix', false );
		$suffix = Helpers::get_value( $settings, 'suffix', false );

		$quantity = 1;
		$item_key = $cart_item_arr = null;
		$bump = false;
		$product = wc_get_product( $product_id );

		$loop_object_type = \Bricks\Query::is_looping() ? \Bricks\Query::get_query_object_type() : false;
		if ( $loop_object_type === 'wooCart' ) {
			$cart_item_arr = \Bricks\Query::get_loop_object();
			$item_key = isset( $cart_item_arr['key'] ) ? $cart_item_arr['key'] : false;
			$product = isset( $cart_item_arr['data'] ) ? $cart_item_arr['data'] : $product;
			$quantity = $cart_item_arr['quantity'];
			$bump = $cart_item_arr['_buob_bump_id'] ?? false;
		} else {
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				if( $cart_item['product_id'] == $product_id || $cart_item['variation_id'] == $product_id ) {
					$quantity = $cart_item['quantity'];
					$bump = $cart_item['_buob_bump_id'] ?? false;
					$item_key = $cart_item_key;
					$cart_item_arr = $cart_item;
					break;
				}
			}
		}

		if( $type == "plain" ) { $this->set_attribute( '_root', 'class', 'quantity' ); }

		$this->set_attribute( '_root', 'data-cart_item_key', $item_key );
		$this->set_attribute( '_root', 'data-product_id', $product_id );
		$this->set_attribute( '_root', 'data-cartupdate', ( isset($settings['disableCartUpdate']) ? 'yes' : 'no') );

		echo "<{$this->tag} {$this->render_attributes('_root')}>";

		if( $prefix ) {
			$this->set_attribute( 'prefixText', 'class', 'prefix-text');
			echo "<span {$this->render_attributes( "prefixText" )}>{$prefix}</span> ";
		}

		if( $type == "plain" ) {
			echo apply_filters( 'woocommerce_widget_cart_item_quantity', $quantity, $cart_item_arr, $item_key );
		} else {
			if( $product == false && ( bricks_is_builder() || Helpers::isBricksBuilderActive() ) ) {
				$product = wc_get_products(
					[
						'limit'   => 1,
						'orderby' => 'date',
						'order'   => 'DESC',
					]
				)[0];
			}

			if( $bump === false ) {
				$hasQtyField = "yes";
			} else {
				$hasQtyField = get_post_meta( $bump, '_buob_has_quantity_field', true ) ?? "no";
			}

			if( $product && $hasQtyField == "yes" ) {
				echo \BricksUltimate\WooCommerce::minCartQty($product, $cart_item_arr, $item_key);
			}
		}

		if( $suffix ) {
			$this->set_attribute( 'suffixText', 'class', 'suffix-text');
			echo " <span {$this->render_attributes( "suffixText" )}>{$suffix}</span>";
		}

		echo "</{$this->tag}>";
	}
}