<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WooCheckoutHooks extends \Bricks\Element {
	public $category = 'checkout';
	public $name 	= 'bu-checkout-hooks';
	public $icon 	= 'ti-plug';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Checkout Hooks', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['hooksInfo'] = [
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Refresh the builder editor for the preview.', 'bricksultimate' ),
		];

		$this->controls['hooks'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Hook', 'bricksultimate' ),
			'options'     => [
				'woocommerce_checkout_before_customer_details' 		=> esc_html__('Before billing/shipping form', 'bricksultimate'),
				'woocommerce_before_checkout_billing_form' 			=> esc_html__('Before billing form', 'bricksultimate'),
				'woocommerce_checkout_before_order_review' 			=> esc_html__('Before order review', 'bricksultimate'),
				'woocommerce_before_order_notes' 					=> esc_html__('Before order notes field', 'bricksultimate'),
				'woocommerce_checkout_before_order_review_heading' 	=> esc_html__('Before order review heading', 'bricksultimate'),
				'woocommerce_review_order_before_cart_contents' 	=> esc_html__('Before cart contents', 'bricksultimate'),
				'woocommerce_before_checkout_shipping_form' 		=> esc_html__('Before shipping form', 'bricksultimate'),
				'woocommerce_review_order_before_order_total' 		=> esc_html__('Before order total', 'bricksultimate'),
				'woocommerce_checkout_after_customer_details' 		=> esc_html__('After billing/shipping form', 'bricksultimate'),
				'woocommerce_after_checkout_billing_form' 			=> esc_html__('After billing form', 'bricksultimate'),
				'woocommerce_checkout_after_order_review' 			=> esc_html__('After order review', 'bricksultimate'),
				'woocommerce_after_order_notes' 					=> esc_html__('After order notes field', 'bricksultimate'),
				'woocommerce_after_checkout_shipping_form' 			=> esc_html__('After shipping form', 'bricksultimate'),
				'woocommerce_review_order_after_cart_contents' 		=> esc_html__('After cart contents', 'bricksultimate'),
				'woocommerce_review_order_after_order_total' 		=> esc_html__('After order total', 'bricksultimate'),
				//'woocommerce_review_order_before_payment' => esc_html__('Review order - Before Payment', 'bricksultimate'),
				//'woocommerce_review_order_after_payment' => esc_html__('Review order - After Payment', 'bricksultimate'),

			],
			'placeholder' => esc_html__( 'Select a hook', 'bricksultimate' ),
		];
	}

	// Render element HTML
	public function render() {
		if( ! empty( $this->settings['hooks'] ) ) {
			if( in_array( $this->settings['hooks'],
				[ 'woocommerce_checkout_before_customer_details', 'woocommerce_checkout_after_customer_details', 'woocommerce_checkout_before_order_review_heading', 'woocommerce_checkout_before_order_review', 'woocommerce_checkout_after_order_review', 'woocommerce_review_order_before_cart_contents', 'woocommerce_review_order_after_cart_contents', 'woocommerce_review_order_before_order_total', 'woocommerce_review_order_after_order_total'
				])
			) {
				do_action( $this->settings['hooks'] );
			} else {
				do_action( $this->settings['hooks'], \WC()->checkout() );
			}
		}
	}
}