<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooPlaceOrderButton extends \Bricks\Element {
	public $category = 'checkout';
	public $name 	= 'bu-place-order';
	public $icon 	= 'ti-control-stop';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Place Order Button', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['btn'] = [
			'title' 	=> esc_html__( 'Button', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['terms'] = [
			'title' 	=> esc_html__( 'Terms and Policy', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['btnText'] = [
			'group' 	=> 'btn',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Button text', 'bricksultimate' ),
			'placeholder' => esc_html__('Place order')
		];

		$selector = '.button';

		$this->controls['btnWidth'] = [
			'group' 	=> 'btn',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnHeight'] = [
			'group' 	=> 'btn',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnPad'] = [
			'group' 	=> 'btn',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnMrgn'] = [
			'group' 	=> 'btn',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnTg'] = [
			'group' 	=> 'btn',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnBg'] = [
			'group' 	=> 'btn',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnBrd'] = [
			'group' 	=> 'btn',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnBoxShadow'] = [
			'group' 	=> 'btn',
			'type'  	=> 'box-shadow',
			'label' 	=> esc_html__( 'Box Shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				]
			],
		];

		$this->controls['priceTg'] = [
			'group' 	=> 'btn',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Price typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector . ' .woocommerce-Price-amount',
				]
			],
		];

		$this->controls['priceSpace'] = [
			'group' 	=> 'btn',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Price spacing', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector . ' .bu-cart-order-total',
				]
			],
		];

		$this->controls['btnIconSep'] = [
			'group' 	=> 'btn',
			'label' => esc_html__('Icon settings', 'bricksultimate'),
			'type' 	=> 'separator',
		];

		$this->controls['btnIcon'] = [
			'group' 	=> 'btn',
			'label' => esc_html__('Icon', 'bricksultimate'),
			'type' 	=> 'icon',
		];

		$this->controls['btnIconSize'] = [
			'group' 	=> 'btn',
			'label'    => esc_html__( 'Size', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ 'btnIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.bu-place-order-btn-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['btnIconColor'] = [
			'group' 	=> 'btn',
			'label'    => esc_html__( 'Icon color', 'bricksultimate' ),
			'type'     => 'color',
			'required' => [ 'btnIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-place-order-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-place-order-btn-icon'
				],
			],
			'rerender' => false
		];

		$this->controls['iconGap'] = [
			'group' 	=> 'btn',
			'label'    => esc_html__( 'Gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ 'btnIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' => 'gap',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['iconPos'] = [
			'group' 	=> 'btn',
			'label'    => esc_html__( 'Put it at right side', 'bricksultimate' ),
			'type'     => 'checkbox',
			'required' => [ 'btnIcon.icon', '!=', '' ],
			'css'      => [
				[
					'property' 	=> 'flex-direction',
					'selector' => $selector,
					'value' 	=> 'row-reverse',
				],
			],
			'rerender' => false
		];

		$this->controls['disableTerms'] = [
			'group' => 'terms',
			'label' => esc_html__( 'Disable terms', 'bricksultimate' ),
			'type'  => 'checkbox'
		];

		$this->controls['termsDesc'] = [
			'group' => 'terms',
			'label' => esc_html__( 'Policy text', 'bricksultimate' ),
			'type'  => 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.woocommerce-privacy-policy-text'
				]
			]
		];

		$this->controls['hideErrorMsg'] = [
			'group' => 'terms',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.checkout-inline-error-message',
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['errorMsg'] = [
			'group' => 'terms',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.checkout-inline-error-message'
				]
			],
			'required' => ['hideErrorMsg', '!=', true]
		];

		$this->controls['cbSep'] = [
			'group' 	=> 'terms',
			'label' => esc_html__('Checkbox', 'bricksultimate'),
			'type' 	=> 'separator',
		];

		/**
		 * Checkbox
		 * ----------------------------------------*/

		$this->controls['cbLabel'] = [
			'group' => 'terms',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.woocommerce-terms-and-conditions-checkbox-text'
				]
			],
		];

		$this->controls['cbLink'] = [
			'group' => 'terms',
			'type' 	=> 'color',
			'label' => esc_html__( 'Link color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'color',
					'selector' => 'a'
				]
			],
		];

		$this->controls['cbAsterisk'] = [
			'group' => 'terms',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide asterisk', 'bricksultimate' ),
			'css'	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> 'abbr[title]',
					'value' 	=> 'none'
				]
			],
		];

		$cb_selector = 'input[type=checkbox]';

		$this->controls['cbsize'] = [
			'group' 	=> 'terms',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'height',
					'selector' => $cb_selector,
				]
			],
		];

		$this->controls['cbbg'] = [
			'group' 	=> 'terms',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_selector,
				]
			],
		];

		$this->controls['cbbrd'] = [
			'group' 	=> 'terms',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_selector,
				]
			]
		];

		$cb_checked = 'input[type=checkbox]:checked';
		$this->controls['cbcbg'] = [
			'group' 	=> 'terms',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_checked,
				]
			],
		];

		$this->controls['cbcbrd'] = [
			'group' 	=> 'terms',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $cb_checked,
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-checkout', Helpers::get_asset_url('css') . 'checkout.min.css', [], filemtime(Helpers::get_asset_path('css') . 'checkout.min.css') );
		} else {*/
			wp_enqueue_script( 'bu-checkout', Helpers::get_asset_url('js') . 'checkout.min.js', [], filemtime(Helpers::get_asset_path('js') . 'checkout.min.js') );
		//}
	}

	public function add_filters() {
		if( ! Helpers::isBricksBuilderActive() || ! bricks_is_builder() ) {
			add_filter('woocommerce_update_order_review_fragments', [$this,'update_place_order_fragments'], 99 );
		}
	}

	public function update_place_order_fragments( $fragments ) {
		parse_str( $_POST['post_data'], $params );

		if( empty( $params ) )
			return $fragments;

		if( empty( $params['po_element_id'] ) )
			return $fragments;

		$post_id = isset( $params['total_post_id'] ) ? $params['total_post_id'] : 0;

		$data = \Bricks\Helpers::get_element_data( $post_id, $params['po_element_id'] );

		$element_instance = new \BricksUltimate\Elements\WooPlaceOrderButton( $data['element'] );
		$element_instance->load();
		ob_start();
		$element_instance->init();

		$fragments['.brxe-bu-place-order'] = ob_get_clean();

		return $fragments;
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		if( ! empty( $settings['disableTerms'] ) ) {
			add_filter( 'woocommerce_checkout_show_terms', '__return_false' );
		}

		$order_button_text = esc_html__( 'Place order', 'woocommerce' );
		$order_button_text = bricks_render_dynamic_data( Helpers::get_value( $settings, 'btnText', $order_button_text) );
		$iconHTML = ! empty( $settings['btnIcon'] ) ? self::render_icon( $settings['btnIcon'], ['bu-place-order-btn-icon'] ) : '';

		$this->set_attribute('_root', 'class', ['place-order']);
		echo "<{$this->tag} {$this->render_attributes('_root')}>";

		add_filter('woocommerce_order_button_text', [$this, 'bu_woocommerce_order_button_text' ] );

		//$data = "data-value='". wp_json_encode([ 'content' => $order_button_text ] ) . "'";
		$data = "data-value='". $order_button_text . "'";
		?>
			<noscript>
				<?php
				printf( esc_html__( 'Since your browser does not support JavaScript, or it is disabled, please ensure you click the %1$sUpdate Totals%2$s button before placing your order. You may be charged more than the amount stated above if you fail to do so.', 'woocommerce' ), '<em>', '</em>' );
				?>
				<br/><button type="submit" class="button alt<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="woocommerce_checkout_update_totals" value="<?php esc_attr_e( 'Update totals', 'woocommerce' ); ?>"><?php esc_html_e( 'Update totals', 'woocommerce' ); ?></button>
			</noscript>

			<?php wc_get_template( 'checkout/terms.php' ); ?>

			<?php do_action( 'woocommerce_review_order_before_submit' ); ?>

			<?php echo apply_filters( 'woocommerce_order_button_html', '<button type="submit" class="place-order-button button alt' . esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ) . '" name="woocommerce_checkout_place_order" id="place_order" value="Place order" ' . $data . '>' . $iconHTML . $order_button_text . '</button>' ); ?>

			<?php do_action( 'woocommerce_review_order_after_submit' ); ?>

			<?php wp_nonce_field( 'woocommerce-process_checkout', 'woocommerce-process-checkout-nonce' ); ?>
		<?php
		echo "</{$this->tag}>";

		if ( ! wp_doing_ajax() ) {
			echo "<input type=\"hidden\" value=\"{$this->id}\" name=\"po_element_id\" >";
			echo "<input type=\"hidden\" value=\"{$this->post_id}\" name=\"total_post_id\" >";
			do_action( 'woocommerce_review_order_after_payment' );
		}
	}

	public function bu_woocommerce_order_button_text( $button_text ) {
		$button_text = esc_html__( 'Place order', 'woocommerce' );
		$button_text = bricks_render_dynamic_data( Helpers::get_value( $this->settings, 'btnText', $button_text) );

		$iconHTML = ! empty( $this->settings['btnIcon'] ) ? self::render_icon( $this->settings['btnIcon'], ['bu-place-order-btn-icon'] ) : '';

		return $iconHTML . $button_text;
	}
}