<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooRemoveCartItem extends \Bricks\Element {
	public $category 		= 'cart';
	public $name 			= 'bu-remove-link';
	public $icon 			= 'ti-close';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Remove Product', 'bricksultimate' );
	}

	public function get_keywords() {
		return [ 'remove', 'remove product', 'delete', 'remove cart item' ];
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['icon']  = array(
			'title' => esc_html__( 'Icon', 'bricks' ),
			'tab'   => 'content',
		);
		$this->control_groups['style'] = array(
			'title' => esc_html__( 'Button Styles', 'bricks' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {

		$this->controls['removeText'] = [
			'tab'         => 'content',
			'type'        => 'text',
			'label'       => esc_html__( 'Remove Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Remove', 'bricks' ),
		];

		$this->controls['ariaLabel'] = [
			'tab'         => 'content',
			'type'        => 'text',
			'label'       => esc_html__( 'Aria label', 'bricksultimate' ),
			'default' 	  => esc_html__( 'Remove this item', 'woocommerce' ),
			'placeholder' => esc_html__( 'Remove this item', 'woocommerce' ),
			'hasDynamicData' => false
		];

		/**
		 * Icon
		 */
		$this->controls['icon'] = [
			'tab'   => 'content',
			'group' => 'icon',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-close',
			],
		];

		$this->controls['iconPosition'] = [
			'tab'         => 'content',
			'group' 	  => 'icon',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Gap', 'bricksultimate' ),
			'type'     	=> 'number',
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css'      	=> [
				[
					'property' => 'gap',
					'selector' => '',
				],
			],
			'placeholder' => '10px',
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Margin', 'bricks' ),
			'type'     	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => '.remove-icon',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group' 	=> 'icon',
			'label'    => esc_html__( 'Size & Color', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.remove-icon',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconHColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '.remove-icon:hover',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		/**
		 * Styles section
		 */
		$selector = '&';

		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'group' 		=> 'style',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display'
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'group' 		=> 'style',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'default' 		=> 'nowrap',
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['direction'] = [
			'tab'      => 'content',
			'group' 	=> 'style',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      		=> 'content',
			'group' 		=> 'style',
			'label'    		=> esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  		=> [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     		=> 'justify-content',
			'css'      		=> [
				[
					'property' => 'justify-content',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      		=> 'content',
			'group' 		=> 'style',
			'label'    		=> esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip' 		=> [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'default' 	=> 'center',
			'required' 	=> [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['spSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Sizing & Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'height'
				]
			]
		];

		//margin field
		$this->controls['margin'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin'
				]
			],
		];

		//padding field
		$this->controls['padding'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding'
				]
			],
		];

		$this->controls['colorsSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Colors & Font', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['backgroundColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnfont'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font'
				],
			]
		];

		$this->controls['brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['bsshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['hoverSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['hBoxshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];

		// POSITIONING

		$this->controls['positionSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' => esc_html__( 'Positioning', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['position'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => \Bricks\Setup::$control_options['position'],
			'css'         => [
				[
					'property' => 'position',
					'selector' => '',
				],
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'Relative', 'bricks' ),
		];

		$this->controls['positionInfo'] = [
			'type'     => 'info',
			'content'  => esc_html__( 'Set "Top" value make this element "sticky".', 'bricks' ),
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'required' => [ '_position', '=', 'sticky' ],
		];

		$this->controls['top'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' => esc_html__( 'Top', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'top',
					'selector' => '',
				],
			],
		];

		$this->controls['right'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' => esc_html__( 'Right', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'right',
					'selector' => '',
				],
			],
		];

		$this->controls['bottom'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' => esc_html__( 'Bottom', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'bottom',
					'selector' => '',
				],
			],
		];

		$this->controls['left'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' => esc_html__( 'Left', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'left',
					'selector' => '',
				],
			],
		];

		$this->controls['zIndex'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label'       => esc_html__( 'Z-index', 'bricks' ),
			'type'        => 'number',
			'css'         => [
				[
					'property' => 'z-index',
					'selector' => '',
				],
			],
			'min'         => -999,
			'placeholder' => 0,
		];

		unset( $this->controls['_spacingSeparator'] );
		unset( $this->controls['_margin'] );
		unset( $this->controls['_padding'] );

		unset( $this->controls['_width'] );
		unset( $this->controls['_height'] );
		unset( $this->controls['_display'] );

		unset( $this->controls['_position'] );
		unset( $this->controls['_positionInfo'] );
		unset( $this->controls['_top'] );
		unset( $this->controls['_right'] );
		unset( $this->controls['_bottom'] );
		unset( $this->controls['_left'] );
		unset( $this->controls['_zIndex'] );
	}

	// Render element HTML
	public function render() {

		if( is_null( WC()->cart ) || WC()->cart->is_empty() )
			return;

		$product_id = $this->post_id;

		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			if( isset( $cart_item['_buob_bump_id'] ) ) {
				$hasButton = get_post_meta( $cart_item['_buob_bump_id'], '_buob_enable_remove_button', true ) ?? "no";

				if( $hasButton == "no" )
					break;

			} 

			if( $cart_item['product_id'] == $product_id || $cart_item['variation_id'] == $product_id ) {

				$output = '';
				$settings = $this->settings;
				$button_text = Helpers::get_value( $settings, 'removeText', false );

				if( $button_text ) {
					$this->set_attribute( '_removeText', 'class', 'remove-text');
					$output .= "<span {$this->render_attributes( "_removeText" )}>{$button_text}</span>";
				}

				$output .= ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'], [ 'class' => [ 'remove-icon' ] ] ) : false;
				
				$this->set_attribute( '_root', 'class', 'remove remove_from_cart_button');
				$this->set_attribute( '_root', 'href', esc_url( wc_get_cart_remove_url( $cart_item_key ) ) );
				$this->set_attribute( '_root', 'aria-label', esc_attr__( Helpers::get_value( $settings, 'ariaLabel', __( 'Remove this item', 'woocommerce' ) ) ) );
				$this->set_attribute( '_root', 'data-product_id', esc_attr( $product_id ) );
				$this->set_attribute( '_root', 'data-cart_item_key', esc_attr( $cart_item_key ) );
				$this->set_attribute( '_root', 'data-product_sku', esc_attr( $cart_item['data']->get_sku() ) );

				echo apply_filters(
					'woocommerce_cart_item_remove_link',
					sprintf(
						'<span class="product-remove"><a %s>%s</a></span>',
						$this->render_attributes( '_root' ),
						$output
					),
					$cart_item_key
				);

				break;
			}
		}
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-remove-link">
			<component 
				:is="'a'" 
				class="remove remove_from_cart_button" 
				:aria-label="settings.ariaLabel"
			>
				<contenteditable tag="span" :name="name" controlKey="removeText" class="remove-text" toolbar="style" :settings="settings"/>
				<icon-svg v-if="settings.icon" class="remove-icon" :iconSettings="settings.icon"/>
			</component>
		</script>
	<?php 
	}
}